﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="DayAccount_List.aspx.cs" Inherits="Ling_DayAccount_List" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/ListHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript">
        var owner = '<%=Request["owner"]%>';
        //搜索
        function search_grid() {
            var fg = document.getElementById("frame_grid");
            var keyword = $("#keyword").val();
            var sort = $("#sort").val();
            var digest = $("#digest").val();
            var remark = $("#remark").val();
            var begin_date = $("#begin_date").val();
            var end_date = $("#end_date").val();
            var cus_name = $("#cus_name").val();
            var vd_name = $("#vd_name").val();
            var ele_name = $("#ele_name").val();
            var cst_name = $("#cst_name").val();
            var above = $("#above").val();
            var equal = $("#equal").val();
            var less = $("#less").val();
            var cus_fit = $("#cus_fit").val();
            var vd_fit = $("#vd_fit").val();

            var url = "DayAccount_Grid.aspx?owner=" + owner + "&keyword=" + keyword + "&sort=" + sort
                    + "&remark=" + remark + "&digest=" + digest
                    + "&begin_date=" + begin_date + "&end_date=" + end_date
                    + "&cus_name=" + cus_name + "&vd_name=" + vd_name 
                    + "&ele_name=" + escape(ele_name) + "&cst_name=" + cst_name
                    + "&above=" + above + "&less=" + less + "&equal=" + equal
                    + "&cus_fit=" + cus_fit + "&vd_fit=" + vd_fit;
            fg.src = url;
        }
        //新增
        function add() {
            asyncbox.open({
                url: 'DayAccount_Edit.aspx?owner=' + owner + '&action=Add',
                modal: true,
                title: '新增日记账'
            });
        }
        //修改
        function modify() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._da_id); //返回一维数组

            if (id.length == 0) {
                AlertNO('请选择要查看的记录!');
                return;
            }
            if (id == "") return;
            asyncbox.open({
                id: 'win_modify',
                url: 'DayAccount_Edit.aspx?owner=' + owner + '&action=Update&id=' + id,
                modal: true,
                title: '修改日记账'
            });

        }
        //删除
        function del() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._da_id); //返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要删除的记录!');
                return;
            }
            asyncbox.confirm('确定要删除所选行吗?\n(可按ctrl或shift键多选)', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: "DayAccount_Service.asmx/Delete",
                        data: "{ids:'" + id + "'}",
                        dataType: 'json',
                        success: function (result) {
                            var r = result.d;
                            if (r == "success") {
                                AlertOK('删除成功!');
                                search_grid();
                            } else {
                                AlertNO(r);
                            }
                            HideLoadingMask(); //关闭遮罩
                        }
                    });
                }
            });
        }
        //选择打印模板
        function grf_print(){
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            choice_print_template('<%=xview["auth_code"]%>',"",cw.sql_print_detail_session_id);
        }
        //小计
        function compute() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._da_id); //返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要小计的记录!');
                return;
            }
            var zc = cw.aw_GetSelectRows(cw._amount_zc); //返回一维数组
            var sum_zc = 0;
            for (var i = 0; i < zc.length; i++) {
                if (!isNaN(zc[i])) {
                    sum_zc += parseFloat(zc[i]);
                }
            }
            AlertOK("选中部分的累计支出金额：" + JSRound(sum_zc,2));
        }
    </script>
</head>
<body onload="search_grid()">
    <!--工具栏-->
    <div style="height:30px;" class="list_menu_bar">
            <select id="sort" style='margin-top:3px;float:left' onchange='search_grid()'>
                <option value="desc">降序</option>
                <option value="asc">升序</option>
            </select>
            <input type="text" class="edit_text_box" id="keyword" style='width:100px;margin-top:3px;float:left'/>
            <a plain="true" class="easyui-linkbutton" onclick="search_grid()">搜索</a>
            <a plain="true" class="easyui-linkbutton" onclick="$('#search_win').window('open')" iconcls="icon-search">高级搜索</a>
            <a plain="true" class="easyui-linkbutton" onclick="add()" style='<%=au.AuthView("Ling_DayAccount_Edit")%>'>新增</a>
            <a plain="true" class="easyui-linkbutton" onclick="modify()" style='<%=au.AuthView("Ling_DayAccount_Edit")%>'>修改</a>
            <a plain="true" class="easyui-linkbutton" onclick="compute()">小计</a>
            <a plain="true" class="easyui-linkbutton" onclick="del()" style='<%=au.AuthView("Ling_DayAccount_Delete")%>'>删除</a>
        <a plain="true" class="easyui-linkbutton" id="btn_print" onclick='grf_print()'>打印</a>
        <a plain="true" class="easyui-linkbutton" onclick="DesignModuleFormat('Ling_DayAccount_List')">格式</a>
    </div>
    <!--Grid控件所在的iframe-->
    <%=xview["grid_frame"]%>
    <!--搜索窗口-->  
	<div id="search_win" class="easyui-dialog" title="搜索"
        data-options="modal:true,closed:true,closable: true,iconCls:'icon-search'"
        style="width:650px;height:300px;padding:10px;">
		<table style="margin:auto;">
            <tr>
                <td style="text-align:right">摘要:</td>
                <td>
                    <input type="text" class="edit_text_box" id="digest" style='width:120px;'/></td>
                <td style="text-align:right">备注:</td>
                <td>
                    <input type="text" class="edit_text_box" id="remark" style='width:120px'/></td>
            </tr>
            <tr>
                <td style="text-align:right">起始日期:</td>
                <td>
                    <input type="text" class="edit_text_box" id="begin_date" style='width:120px' onclick='ShowDateControl()'/></td>
                <td style="text-align:right">截止日期:</td>
                <td>
                    <input type="text" class="edit_text_box" id="end_date" style='width:120px' onclick='ShowDateControl()'/></td>
            </tr>

            <tr>
                <td style="text-align:right">工地:</td>
                <td>
                    <input type="text" class="edit_text_box" id="cus_name" style='width:98px'/>
                    <select id='cus_fit'>
                        <option value='1'>精确</option>
                        <option value='0'>模糊</option>
                    </select></td>
                <td style="text-align:right">供应商:</td>
                <td>
                    <input type="text" class="edit_text_box" id="vd_name" style='width:98px'/>
                    <select id='vd_fit'>
                        <option value='1'>精确</option>
                        <option value='0'>模糊</option>
                    </select></td>
            </tr>
            <tr>
                <td style="text-align:right">员工:</td>
                <td><input type="text" class="edit_text_box" id="ele_name" style='width:98px'/></td>
                <td style="text-align:right">费用:</td>
                <td><input type="text" class="edit_text_box" id="cst_name" style='width:98px'/></td>
            </tr>
            <tr>
                <td style="text-align:right">金额范围:</td>
                <td>
                    ><input type="text" class="edit_text_box" id="above" style="width:40px;float:none"/>
                    =<input type="text" class="edit_text_box" id="equal" style="width:40px;float:none"/>
                    <<input type="text" class="edit_text_box" id="less" style="width:40px;float:none"/>
                    </td>
            </tr>
		</table>
        <div style="margin-top:20px;text-align:center">
            <a href="javascript:search_grid()" class="easyui-linkbutton" onclick="javascript:$('#search_win').dialog('close')">搜索</a>
            <a class="easyui-linkbutton" onClick="javascript:$('#search_win').dialog('close')">取消</a>
        </div>
	</div>
    <!--end of 搜索窗口--> 
    <script type="text/javascript">
        $(document).ready(function () {
            FastSearch_Customer(); //查询客户
            FastSearch_Vendor(); //查询供应商
            FastSearch_Employee(); //查询员工
            FastSearch_Cost(); //查询费用
            $F("keyword").focus();
            $F("keyword").onkeypress = function (evt) {
                evt = evt ? evt : (window.event ? window.event : null);
                if (evt.keyCode == "13") {
                    search_grid();
                }
            }
        });
    </script>
</body>
</html>
