﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;
public partial class Ling_DayAccount_Grid : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    AWGridFun aw = new AWGridFun();
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!Page.IsPostBack)
        {
            CreateGrid();
        }
    }
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        //设置标题与样式
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        string sql_select_field = "";//SQL所需选择列
        string module = "Ling_DayAccount_List";//模块
        string fields_index = "";//列索引
        mfd.CreateTitlesAndStyles(module, ref aw, ref sql_select_field, ref fields_index);
        xview.Add("fields_index", fields_index);
        //把样式传递到页面
        xview.Add("aw_column_style",aw.GetStyles());
        int page = 1;//当前页
        if (Request.QueryString["page"] != null)
            page = Convert.ToInt32(Request.QueryString["page"]);
        int page_size = aw.GetDefaultPageSize();//每页显示条数
        page_size = 100;//每页显示条数
        if (Request.QueryString["page_size"] != null)
            page_size = Convert.ToInt32(Request.QueryString["page_size"]);
        
        Hashtable ht = new Hashtable();
        //排序
        string sort = Request.QueryString["sort"];
        string order_field = "order by add_Date " + sort + ",da_id " + sort;
        ht.Add("order_field", order_field);
        ht.Add("owner", Request.QueryString["owner"]);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";

        if (!Request["keyword"].Equals(""))
        {
            string keyword = Request["keyword"].ToString();
            sql_end = FastSearh.MakeSearchSqlForWhere(keyword, "remark,digest,cus_name,vd_name,ele_name,cst_name");
        }
        if (!Request["begin_date"].Equals(""))
        {
            sql_end += " and add_date>='" + Request["begin_date"] + "'";
        }
        if (!Request["end_date"].Equals(""))
        {
            sql_end += " and add_date<='" + Request["end_date"] + "'";
        }
        if (!Request["remark"].Equals(""))
        {
            sql_end += " and remark like '%" + Request["remark"] + "%'";
        }
        if (!Request["digest"].Equals(""))
        {
            sql_end += " and digest like '%" + Request["digest"] + "%'";
        }
        if (!Request["cus_name"].Equals(""))
        {
            if (Request.QueryString["cus_fit"].Equals("1"))
            {
                sql_end += " and cus_name='" + Request["cus_name"] + "'";
            }
            else
            {
                sql_end += " and cus_name like '%" + Request["cus_name"] + "%'";
            }
        }
        if (!Request["vd_name"].Equals(""))
        {
            if (Request.QueryString["vd_fit"].Equals("1"))
            {
                sql_end += " and vd_name ='" + Request["vd_name"] + "'";
            }
            else
            {
                sql_end += " and vd_name like '%" + Request["vd_name"] + "%'";
            }
        }
        if (!Request["ele_name"].Equals(""))
        {
            sql_end += " and ele_name like '%" + Request["ele_name"] + "%'";
        }
        if (!Request["cst_name"].Equals(""))
        {
            sql_end += " and cst_name like '%" + Request["cst_name"] + "%'";
        }
        if (!Request["above"].Equals(""))
        {
            sql_end += " and amount>" + Request["above"];
        }
        if (!Request["equal"].Equals(""))
        {
            sql_end += " and amount=" + Request["equal"];
        }
        if (!Request["less"].Equals(""))
        {
            sql_end += " and amount<" + Request["less"];
        }
        if (!Request["owner"].Equals(""))
        {
            sql_end += " and owner=" + Request["owner"];
        }
        DayAccountDAL dal = new DayAccountDAL();

        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = dal.GetList(ht, sql_select_field);
        //把sql放入session中供打印用
        string sql_print_detail_session_id = "sql_print_detail_DayAccount";
        Session[sql_print_detail_session_id] = dal.sql_print;
        //Response.Write(dal.sql_print);
        xview.Add("sql_print_detail_session_id", sql_print_detail_session_id);
        //得到总记录数为分页提供依据
        int rows_count = dal.GetList_TotalNumbers(ht);
        //开启合计行功能
        aw.to_sum_row = true;
        //从模板读出哪些列需要合计
        aw.last_row_info = mfd.last_row_info;
        string aw_grid_info = aw.MakeGridObject(dt, rows_count, page_size, page);
        //把控件参数与数据源传递到页面
        xview.Add("aw_grid_info", aw_grid_info); 
    }
}
