﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;
public partial class Ling_CustomerDetails_Grid : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    AWGridFun aw = new AWGridFun();
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!Page.IsPostBack)
        {
            CreateGrid();
        }
    }
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        //设置标题与样式
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        string sql_select_field = "";//SQL所需选择列
        string module = "Ling_CustomerDetails_List";//模块
        string fields_index = "";//列索引
        mfd.CreateTitlesAndStyles(module, ref aw, ref sql_select_field, ref fields_index);
        xview.Add("fields_index", fields_index);
        //把样式传递到页面
        xview.Add("aw_column_style",aw.GetStyles());
        int page = 1;//当前页
        if (Request.QueryString["page"] != null)
            page = Convert.ToInt32(Request.QueryString["page"]);
        int page_size = aw.GetDefaultPageSize();//每页显示条数
        page_size = 300;//每页显示条数
        if (Request.QueryString["page_size"] != null)
            page_size = Convert.ToInt32(Request.QueryString["page_size"]);
        
        Hashtable ht = new Hashtable();
        //排序
        string sort = Request.QueryString["sort"];
        string order_field = "order by cus_name asc,add_Date " + sort + ",da_id " + sort;
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";

        if (!Request["keyword"].Equals(""))
        {
            string keyword = Request["keyword"].ToString();
            sql_end = FastSearh.MakeSearchSqlForWhere(keyword, "digest,cus_name,vd_name,ele_name");
        }
        if (!Request["begin_date"].Equals(""))
        {
            sql_end += " and add_date>='" + Request["begin_date"] + "'";
        }
        if (!Request["end_date"].Equals(""))
        {
            sql_end += " and add_date<='" + Request["end_date"] + "'";
        }
        if (!Request["digest"].Equals(""))
        {
            sql_end += " and digest like '%" + Request["digest"] + "%'";
        }
        if (!Request["cus_name"].Equals(""))
        {
            if (Request.QueryString["cus_fit"].Equals("1"))
            {
                sql_end += " and cus_name='" + Request["cus_name"] + "'";
            }
            else
            {
                sql_end += " and cus_name like '%" + Request["cus_name"] + "%'";
            }
        }
        if (!Request["vd_name"].Equals(""))
        {
            if (Request.QueryString["vd_fit"].Equals("1"))
            {
                sql_end += " and vd_name ='" + Request["vd_name"] + "'";
            }
            else
            {
                sql_end += " and vd_name like '%" + Request["vd_name"] + "%'";
            }
        }
        if (!Request["ele_name"].Equals(""))
        {
            sql_end += " and ele_name like '%" + Request["ele_name"] + "%'";
        }
        
        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = GetList(ht, sql_select_field);
        //把sql放入session中供打印用
        string sql_print_detail_session_id = "sql_print_detail_CustomerDetails";
        Session[sql_print_detail_session_id] = sql_print;
        xview.Add("sql_print_detail_session_id", sql_print_detail_session_id);
        //得到总记录数为分页提供依据
        int rows_count = GetList_TotalNumbers(ht);
        //开启合计行功能
        aw.to_sum_row = true;
        //从模板读出哪些列需要合计
        aw.last_row_info = mfd.last_row_info;
        string aw_grid_info = aw.MakeGridObject(dt, rows_count, page_size, page);
        //把控件参数与数据源传递到页面
        xview.Add("aw_grid_info", aw_grid_info); 
    }
    //打印用的sql
    public string sql_print = "";
    string sql_list = @"
                    select da.da_id,cus.cus_name,
                    convert(char(10),da.add_date,23) as add_date,
                    case when da.direction='收入' then da.amount else '' end as jin_zhang,
                    da.digest,vd.vd_name,ele.ele_name,
                    case when cst.cst_name='其它费用' then da.amount else 0 end as jin_e,
                    case when cst.cst_name='水电工' then da.amount else 0 end as shui_dian_gong,
                    case when cst.cst_name='泥工' then da.amount else 0 end as ni_gong,
                    case when cst.cst_name='木工' then da.amount else 0 end as mu_gong,
                    case when cst.cst_name='油漆工' then da.amount else 0 end as you_qi_gong,
                    case when cst.cst_name='外墙工班' then da.amount else 0 end as wai_qiang,
                    case when cst.cst_name='杂工' then da.amount else 0 end as za_gong,
                    case when da.direction!='收入' then da.amount else 0 end as he_ji
                    from Ling_DayAccount da
                    left join Base_Customer cus on cus.cus_id=da.cus_id
                    left join Base_Vendor vd on vd.vd_id=da.vd_id
                    left join Base_Employee ele on ele.ele_id=da.ele_id
                    left join Base_Cost cst on cst.cst_id=da.cst_id
                    where isnull(da.cus_id,'')<>''";
    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        string order_field = pg["order_field"].ToString();
        string sql = "select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field from(" + sql_list + ")t where 1=1 ";

        sql = sql.Replace("@order_field", order_field)
                 .Replace("@sql_select_field", sql_select_field);
        sql_print = sql_list + " " + pg["sql_end"] + " " + pg["order_field"].ToString();
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        var sql = "select count(1) from (" + sql_list + ")t where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
}
