﻿<%@ WebService Language="C#" Class="SalesOrderIF" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Data;
using System.Collections;
using System.Transactions;
using SysCore;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
 [System.Web.Script.Services.ScriptService]
public class SalesOrderIF  : System.Web.Services.WebService {
    /// <summary>
    /// 新增销售订单
    /// </summary>
    /// <param name="cus_id">客户ID</param>
    /// <param name="ele_id">业务员ID</param>
    /// <param name="contact">联系人</param>
    /// <param name="phone">电话</param>
    /// <param name="ship_address">地址</param>
    /// <param name="remark">订单备注</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string AddOrder(string cus_id, string ele_id, string contact, string phone, string ship_address, string remark)
    {
        try
        {
            int uid = new LoginInfo().uid;
            SalesOrder t = new SalesOrder();
            t.new_date = Convert.ToDateTime(XTools.DateTimeToStandard(DateTime.Now));
            /*
            if (!cus_id.Equals(""))
            {
                t.cus_id = XTools.ObjectNullToInt(cus_id);
            }
            else
            {
                string phone_sale_customer = new ConfigReader().GetConfig("phone_sale_customer");
                if (!phone_sale_customer.Trim().Equals(""))
                {

                    t.cus_id = new CustomerDAL().GetIdByCode(phone_sale_customer);
                }
            }*/
            if (cus_id.Equals(""))
            {
                return "请选择客户";
            }
            t.cus_id = XTools.ObjectNullToInt(cus_id);
            if (!ele_id.Equals(""))
            {
                t.ele_id = XTools.ObjectNullToInt(ele_id);
            }
            else
            {
                string phone_sale_employee = new ConfigReader().GetConfig("phone_sale_employee");
                if (phone_sale_employee.Trim().Equals(""))
                {
                    //return "请先到参数配置模块设置默认业务员编码";
                }
                else
                {
                    t.ele_id = new EmployeeDAL().GetIdByCode(phone_sale_employee);
                }
            }
            t.contact = contact;
            t.phone = phone;
            t.ship_address = ship_address;
            t.remark = remark;
            if (!ele_id.Equals(""))
            {
                t.dep_id = new EmployeeDAL().Get(Convert.ToInt32(ele_id)).department.dep_id;
            }
            /*
            string phone_sale_saletype = new ConfigReader().GetConfig("phone_sale_saletype");
            if (phone_sale_saletype.Trim().Equals(""))
            {
                //return "请先到参数配置模块设置默认销售类型编码";
            }
            else
            {
                int st_id = new SaleTypeDAL().GetIdByCode(phone_sale_saletype);
                t.st_id = st_id;
            }*/
            //本位币
            t.crc_id =  new CurrencyDAL().GetStandard().crc_id;
            //汇率
            t.exchange_rate = new CurrencyRateDAL().GetCurrentMonthExchangeRate(Convert.ToInt32(t.crc_id));

            LoginInfo li = new LoginInfo();
            t.new_uid = li.uid;
            t.new_user = li.nickname;//新增人名称
            
            t.order_number = "";
            SalesOrderDAL dal = new SalesOrderDAL();
            //启用事务
            using (TransactionScope scope = new TransactionScope())
            {
                //新增订单主表
                dal.Add(t);
                //得到新增保存后的最大ID号
                int MaxID = dal.GetMaxID();
                t.so_id = MaxID;
                t = dal.Get(MaxID);
                //如果流水号为空代表是系统自动流水

                //根据规则生成流水号
                Hashtable ht_num = new Hashtable();
                if (t.customer != null)
                    ht_num.Add("[cus_code]", t.customer.cus_code);
                if (t.department != null)
                    ht_num.Add("[dep_code]", t.department.dep_code);
                if (t.saletype != null)
                    ht_num.Add("[st_code]", t.saletype.st_code);
                if (t.employee != null)
                    ht_num.Add("[ele_code]", t.employee.ele_code);
                string running_number = new RunningNumberRuleDAL().GetModuleRunningNumber("Sale_SalesOrder", ht_num);
                t.order_number = running_number;
                //更新实体
                dal.Update(t);

                new UserLogDAL().AddUserLog("销售订单", "新增单据", t.so_id, t.order_number);

                CartDAL ct_dal = new CartDAL();
                SalesOrdersDAL sos_dal = new SalesOrdersDAL();
                DataTable dt_ct = ct_dal.GetCartListByUser(uid);
                //遍历购物车
                foreach (DataRow dr in dt_ct.Rows)
                {
                    Cart ct = new Cart();
                    SalesOrders sos = new SalesOrders();
                    sos.so_id = t.so_id;
                    sos.i_id = Convert.ToInt32(dr["i_id"]);
                    sos.quantity = XTools.ObjectNullToDecimal(dr["quantity"]);
                    sos.tax_unit_price = XTools.ObjectNullToDecimal(dr["tax_unit_price"]);//含税单价
                    sos.tax_total_price = Math.Round(Convert.ToDecimal(sos.tax_unit_price * sos.quantity), 2);//含税金额
                    sos.unit_price = sos.tax_unit_price;//无税单价
                    sos.total_price = sos.tax_total_price;//无税金额
                    sos.tax = 0;//税额
                    sos.d_tax_rate = 0;//税率
                    sos.nat_tax = 0;//本币税额
                    sos.nat_tax_unit_price = sos.tax_unit_price;//本币含税单价
                    sos.nat_tax_total_price = sos.tax_total_price;//本币含税金额
                    sos.nat_unit_price = sos.unit_price;//本币单价
                    sos.nat_total_price = sos.total_price;//无币金额
                    sos.free1 = XTools.ObjectNullToString(dr["free1"]);
                    sos.free2 = XTools.ObjectNullToString(dr["free2"]);
                    //新增订单子表
                    sos_dal.Add(sos);
                }
                //清空购物车
                ct_dal.DeleteCartByUser(uid);
                
                //提交事务
                scope.Complete();
            }//end of trans
            return "success|" + t.so_id.ToString();
        }
        catch (Exception err)
        {
            return err.Message;
        }
    }
    
}