﻿
/*
alter table [System_Module] add flow_url [nvarchar](255)
alter table Base_Customer add ele_id int
alter table Base_Vendor add ele_id int
alter table Base_Employee add entry_date datetime,exit_date datetime
*/

if (select count(1) from System_Module where module_code='Ling')=0
begin
	insert System_Module(category,module_code,module_name,sort,auth_code,node_img,url)
	select null category,'Ling' as module_code,'财务' as module_name,
	90 as sort,'Ling' as auth_code,'Memo.png' as node_img,null as url;
end

if (select count(1) from System_Module where module_code='Ling_DayAccount')=0
begin
	insert System_Module(category,module_code,module_name,sort,auth_code,node_img,url)
	select 'Ling' category,'Ling_DayAccount' as module_code,'李玲日记账' as module_name,
	10 as sort,'Ling_DayAccount' as auth_code,'Tick.png' as node_img,
  '../../Ling/DayAccount/DayAccount_List.aspx?owner=1' as url;
end
if (select count(1) from System_Module where module_code='Ling_DayAccountXJ')=0
begin
	insert System_Module(category,module_code,module_name,sort,auth_code,node_img,url)
	select 'Ling' category,'Ling_DayAccountXJ' as module_code,'现金日记账' as module_name,
	15 as sort,'Ling_DayAccountXJ' as auth_code,'Stock.png' as node_img,
  '../../Ling/DayAccount/DayAccount_List.aspx?owner=3' as url;
end
if (select count(1) from System_Module where module_code='Ling_DayAccountBoss')=0
begin
	insert System_Module(category,module_code,module_name,sort,auth_code,node_img,url)
	select 'Ling' category,'Ling_DayAccountBoss' as module_code,'老板日记账' as module_name,
	20 as sort,'Ling_DayAccountBoss' as auth_code,'Boss.png' as node_img,
  '../../Ling/DayAccount/DayAccount_List.aspx?owner=2' as url;
end
if (select count(1) from System_Module where module_code='Ling_DayAccountDongGuan')=0
begin
	insert System_Module(category,module_code,module_name,sort,auth_code,node_img,url)
	select 'Ling' category,'Ling_DayAccountDongGuan' as module_code,'杨总东莞行账' as module_name,
	22 as sort,'Ling_DayAccountDongGuan' as auth_code,'Blank.png' as node_img,
  '../../Ling/DayAccount/DayAccount_List.aspx?owner=4' as url;
end
if (select count(1) from System_Module where module_code='Ling_DayAccountCheHang')=0
begin
	insert System_Module(category,module_code,module_name,sort,auth_code,node_img,url)
	select 'Ling' category,'Ling_DayAccountCheHang' as module_code,'车行记账' as module_name,
	23 as sort,'Ling_DayAccountCheHang' as auth_code,'Memo.png' as node_img,
  '../../Ling/DayAccount/DayAccount_List.aspx?owner=5' as url;
end
if (select count(1) from System_Module where module_code='Ling_YingFu')=0
begin
	insert System_Module(category,module_code,module_name,sort,auth_code,node_img,url)
	select 'Ling' category,'Ling_YingFu' as module_code,'应付' as module_name,
	30 as sort,'Ling_YingFu' as auth_code,'day.png' as node_img,
  '../../Ling/YingFu/YingFu_List.aspx' as url;
end
if (select count(1) from System_Module where module_code='Ling_CustomerDetails')=0
begin
	insert System_Module(category,module_code,module_name,sort,auth_code,node_img,url)
	select 'Ling' category,'Ling_CustomerDetails' as module_code,'工地账目明细表' as module_name,
	40 as sort,'Ling_CustomerDetails' as auth_code,'Report.png' as node_img,
  '../../Ling/CustomerDetails/CustomerDetails_List.aspx' as url;
end
if (select count(1) from System_Module where module_code='Ling_BanZu')=0
begin
	insert System_Module(category,module_code,module_name,sort,auth_code,node_img,url)
	select 'Ling' category,'Ling_BanZu' as module_code,'班组长账目明细表' as module_name,
	50 as sort,'Ling_BanZu' as auth_code,'Report.png' as node_img,
  '../../Ling/BanZu/BanZu_List.aspx' as url;
end

if (select count(1) from System_Module where module_code='Ling_VendorYingFu')=0
begin
	insert System_Module(category,module_code,module_name,sort,auth_code,node_img,url)
	select 'Ling' category,'Ling_VendorYingFu' as module_code,'供应商账目明细表' as module_name,
	60 as sort,'Ling_VendorYingFu' as auth_code,'Report.png' as node_img,
  '../../Ling/VendorYingFu/VendorYingFu_List.aspx' as url;
end

delete System_Module where module_code like 'Stock%' or module_code like 'Sale%' or module_code like 'Purchase%'
delete System_Module where module_code like 'Base%' and module_code not in ('Base','Base_Department','Base_Employee','Base_Customer','Base_Vendor','Base_Cost')

--现金日记账表
if object_id('Ling_DayAccount') is null
begin
	CREATE TABLE Ling_DayAccount(
		da_id int identity(1,1),
		add_date datetime,--发生日期
		direction nvarchar(4),--方向
		amount float,--金额
		cus_id int,--客户
		vd_id int,--供应商
		ele_id int,--员工
		cst_id int,--费用
		owner int,--流水使用者
		digest nvarchar(500),--摘要
		remark nvarchar(500)--备注
	)
	--外键约束
	ALTER TABLE [dbo].[Ling_DayAccount]  WITH CHECK ADD  CONSTRAINT [FK_Ling_DayAccount_Base_Customer] FOREIGN KEY([cus_id])
	REFERENCES [dbo].[Base_Customer] ([cus_id]);
	ALTER TABLE [dbo].[Ling_DayAccount]  WITH CHECK ADD  CONSTRAINT [FK_Ling_DayAccount_Base_Vendor] FOREIGN KEY([vd_id])
	REFERENCES [dbo].[Base_Vendor] ([vd_id]);
	ALTER TABLE [dbo].[Ling_DayAccount]  WITH CHECK ADD  CONSTRAINT [FK_Ling_DayAccount_Base_Employee] FOREIGN KEY([ele_id])
	REFERENCES [dbo].[Base_Employee] ([ele_id]);
	ALTER TABLE [dbo].[Ling_DayAccount]  WITH CHECK ADD  CONSTRAINT [FK_Ling_DayAccount_Base_Cost] FOREIGN KEY([cst_id])
	REFERENCES [dbo].[Base_Cost] ([cst_id]);
end
/**/GO

if (select count(1) from System_Auth where auth_code='Ling_DayAccount')=0
begin
	insert System_Auth(auth_code,auth_name)
	select 'Ling_DayAccount','查看'
	union all
	select 'Ling_DayAccount_Edit','编辑'
	union all
	select 'Ling_DayAccount_Delete','删除'
end
/**/GO
if (select count(1) from System_Auth where auth_code='Ling_DayAccountBoss')=0
begin
	insert System_Auth(auth_code,auth_name)
	select 'Ling_DayAccountBoss','查看'
end
/**/GO

--应付表
if object_id('Ling_YingFu') is null
begin
	CREATE TABLE Ling_YingFu(
		yf_id int identity(1,1),
		add_date datetime,--日期
		amount float,--金额
		cus_id int,--客户
		vd_id int,--供应商
		ele_id int,--员工
		cst_id int,--费用
		digest nvarchar(500),--摘要
		remark nvarchar(500)--备注
	)
	--外键约束
	ALTER TABLE [dbo].[Ling_YingFu]  WITH CHECK ADD  CONSTRAINT [FK_Ling_YingFu_Base_Customer] FOREIGN KEY([cus_id])
	REFERENCES [dbo].[Base_Customer] ([cus_id]);
	ALTER TABLE [dbo].[Ling_YingFu]  WITH CHECK ADD  CONSTRAINT [FK_Ling_YingFu_Base_Vendor] FOREIGN KEY([vd_id])
	REFERENCES [dbo].[Base_Vendor] ([vd_id]);
	ALTER TABLE [dbo].[Ling_YingFu]  WITH CHECK ADD  CONSTRAINT [FK_Ling_YingFu_Base_Employee] FOREIGN KEY([ele_id])
	REFERENCES [dbo].[Base_Employee] ([ele_id]);
	ALTER TABLE [dbo].[Ling_YingFu]  WITH CHECK ADD  CONSTRAINT [FK_Ling_YingFu_Base_Cost] FOREIGN KEY([cst_id])
	REFERENCES [dbo].[Base_Cost] ([cst_id]);
end
/**/GO

if (select count(1) from System_Auth where auth_code='Ling_YingFu')=0
begin
	insert System_Auth(auth_code,auth_name)
	select 'Ling_YingFu','查看'
	union all
	select 'Ling_YingFu_Edit','编辑'
	union all
	select 'Ling_YingFu_Delete','删除'
end
/**/GO

if (select count(1) from System_Auth where auth_code='Ling_CustomerDetails_List')=0
begin
	insert System_Auth(auth_code,auth_name)
	select 'Ling_CustomerDetails_List','工地账目明细表';

	insert System_Auth(auth_code,auth_name)
	select 'Ling_BanZu_List','班组长账目明细表';

	insert System_Auth(auth_code,auth_name)
	select 'Ling_VendorYingFu_List','供应商账目明细表';
end
/**/GO

--增加打印模板-日记账
if((select count(1) from System_PrintTemplate where is_system=1 and module='Ling_DayAccount_List' and template_name='现金日记账')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Ling_DayAccount_List','现金日记账',1,'../GrfFile/Ling_DayAccount.grf';
end
/**/GO
--增加打印模板-应付
if((select count(1) from System_PrintTemplate where is_system=1 and module='Ling_YingFu_List' and template_name='应付')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Ling_YingFu_List','应付',1,'../GrfFile/Ling_YingFu.grf';
end
/**/GO
--增加打印模板-工地账目明细表
if((select count(1) from System_PrintTemplate where is_system=1 and module='Ling_CustomerDetails_List' and template_name='工地账目明细表')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Ling_CustomerDetails_List','工地账目明细表',1,'../GrfFile/Ling_CustomerDetails.grf';
end
/**/GO
--增加打印模板-班组长账目明细表
if((select count(1) from System_PrintTemplate where is_system=1 and module='Ling_BanZu_List' and template_name='班组长账目明细表')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Ling_BanZu_List','班组长账目明细表',1,'../GrfFile/Ling_BanZu.grf';
end
/**/GO

--增加打印模板-供应商账目明细表
if((select count(1) from System_PrintTemplate where is_system=1 and module='Ling_VendorYingFu_List' and template_name='供应商账目明细表')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Ling_VendorYingFu_List','供应商账目明细表',1,'../GrfFile/Ling_VendorYingFu.grf';
end
/**/GO

--插入[现金日记账]列表界面格式
--delete System_ModuleFormat where module='Ling_DayAccount_List'
if(select count(1) from System_ModuleFormat where module='Ling_DayAccount_List' and field='da_id')=0
begin
	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_List' as module,'da_id' as field,
	'ID' as field_name,'ID' as title,
	120 as width,100 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_List' as module,'add_date' as field,
	'发生日期' as field_name,'发生日期' as title,
	70 as width,110 as sort,1 as show,0 as hidden,0 as sum_field,'date' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_List' as module,'digest' as field,
	'摘要' as field_name,'摘要' as title,
	200 as width,120 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_select,can_edit)
	select 'Ling_DayAccount_List' as module,'direction' as field,
	'借贷方向' as field_name,'借贷方向' as title,
	80 as width,130 as sort,0 as show,0 as hidden,0 as sum_field,'list' as type,0 as can_select,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_List' as module,'cus_id' as field,
	'工地ID' as field_name,'工地ID' as title,
	120 as width,140 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_List' as module,'cus_name' as field,
	'工地' as field_name,'工地' as title,
	100 as width,150 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_List' as module,'vd_id' as field,
	'供应商ID' as field_name,'供应商ID' as title,
	120 as width,160 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_List' as module,'vd_name' as field,
	'供应商' as field_name,'供应商' as title,
	100 as width,170 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_List' as module,'ele_id' as field,
	'员工ID' as field_name,'员工ID' as title,
	120 as width,180 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_List' as module,'ele_name' as field,
	'员工' as field_name,'员工' as title,
	60 as width,190 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_List' as module,'amount_sr' as field,
	'收入金额' as field_name,'收入金额' as title,
	60 as width,200 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_List' as module,'amount_zc' as field,
	'支出金额' as field_name,'支出金额' as title,
	60 as width,210 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_List' as module,'amount_jc' as field,
	'结存金额' as field_name,'结存金额' as title,
	60 as width,220 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_List' as module,'cst_id' as field,
	'费用类型ID' as field_name,'费用类型ID' as title,
	120 as width,230 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_List' as module,'cst_name' as field,
	'费用类型' as field_name,'费用类型' as title,
	60 as width,240 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_List' as module,'remark' as field,
	'备注' as field_name,'备注' as title,
	200 as width,260 as sort,1 as show,0 as hidden,0 as sum_field,'textarea' as type,1 as can_edit;
end
/**/GO

--插入[现金日记账]列表界面格式
--delete System_ModuleFormat where module='Ling_DayAccount_Input'
if(select count(1) from System_ModuleFormat where module='Ling_DayAccount_Input' and field='da_id')=0
begin
	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_Input' as module,'da_id' as field,
	'ID' as field_name,'ID' as title,
	120 as width,100 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_Input' as module,'add_date' as field,
	'发生日期' as field_name,'发生日期' as title,
	120 as width,110 as sort,1 as show,0 as hidden,0 as sum_field,'date' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_Input' as module,'digest' as field,
	'摘要' as field_name,'摘要' as title,
	200 as width,120 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_select,can_edit)
	select 'Ling_DayAccount_Input' as module,'direction' as field,
	'借贷方向' as field_name,'借贷方向' as title,
	103 as width,130 as sort,1 as show,0 as hidden,0 as sum_field,'list' as type,0 as can_select,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_Input' as module,'amount' as field,
	'金额' as field_name,'金额' as title,
	120 as width,140 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_Input' as module,'cus_id' as field,
	'工地ID' as field_name,'工地ID' as title,
	120 as width,150 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_Input' as module,'cus_name' as field,
	'工地' as field_name,'工地' as title,
	98 as width,160 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_Input' as module,'vd_id' as field,
	'供应商ID' as field_name,'供应商ID' as title,
	120 as width,170 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_Input' as module,'vd_name' as field,
	'供应商' as field_name,'供应商' as title,
	98 as width,180 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_Input' as module,'ele_id' as field,
	'员工ID' as field_name,'员工ID' as title,
	120 as width,190 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_Input' as module,'ele_name' as field,
	'员工' as field_name,'员工' as title,
	98 as width,200 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_Input' as module,'cst_id' as field,
	'费用类型ID' as field_name,'费用类型ID' as title,
	120 as width,210 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_Input' as module,'cst_name' as field,
	'费用类型' as field_name,'费用类型' as title,
	98 as width,220 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_DayAccount_Input' as module,'remark' as field,
	'备注' as field_name,'备注' as title,
	200 as width,230 as sort,1 as show,0 as hidden,0 as sum_field,'textarea' as type,1 as can_edit;
end
/**/GO



--插入[现金日记账]列表界面格式
--delete System_ModuleFormat where module='Ling_CustomerDetails_List'
if(select count(1) from System_ModuleFormat where module='Ling_CustomerDetails_List' and field='da_id')=0
begin
	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_CustomerDetails_List' as module,'da_id' as field,
	'ID' as field_name,'ID' as title,
	80 as width,100 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_CustomerDetails_List' as module,'cus_name' as field,
	'工地' as field_name,'工地' as title,
	100 as width,110 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_CustomerDetails_List' as module,'add_date' as field,
	'发生日期' as field_name,'发生日期' as title,
	70 as width,120 as sort,1 as show,0 as hidden,0 as sum_field,'date' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_CustomerDetails_List' as module,'jin_zhang' as field,
	'进账' as field_name,'进账' as title,
	60 as width,130 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_CustomerDetails_List' as module,'digest' as field,
	'摘要' as field_name,'摘要' as title,
	150 as width,140 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_CustomerDetails_List' as module,'vd_name' as field,
	'供应商' as field_name,'供应商' as title,
	60 as width,150 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_CustomerDetails_List' as module,'ele_name' as field,
	'员工' as field_name,'员工' as title,
	60 as width,151 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_CustomerDetails_List' as module,'jin_e' as field,
	'其它费用' as field_name,'其它费用' as title,
	60 as width,160 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_CustomerDetails_List' as module,'shui_dian_gong' as field,
	'水电工' as field_name,'水电工' as title,
	60 as width,170 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_CustomerDetails_List' as module,'ni_gong' as field,
	'泥工' as field_name,'泥工' as title,
	60 as width,180 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_CustomerDetails_List' as module,'mu_gong' as field,
	'木工' as field_name,'木工' as title,
	60 as width,190 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_CustomerDetails_List' as module,'you_qi_gong' as field,
	'油漆工' as field_name,'油漆工' as title,
	60 as width,200 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_CustomerDetails_List' as module,'wai_qiang' as field,
	'外墙工班' as field_name,'外墙工班' as title,
	60 as width,210 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_CustomerDetails_List' as module,'za_gong' as field,
	'杂工' as field_name,'杂工' as title,
	60 as width,220 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_CustomerDetails_List' as module,'he_ji' as field,
	'合计' as field_name,'合计' as title,
	60 as width,230 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;
end
/**/GO




 
--插入[班组长账目明细表]列表界面格式
--delete System_ModuleFormat where module='Ling_BanZu_List'
if(select count(1) from System_ModuleFormat where module='Ling_BanZu_List' and field='ele_name')=0
begin
	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'ele_name' as field,
	'班组长' as field_name,'班组长' as title,
	60 as width,100 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'cellphone' as field,
	'电话' as field_name,'电话' as title,
	80 as width,110 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'cus_name' as field,
	'工地' as field_name,'工地' as title,
	100 as width,120 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'cst_name' as field,
	'项目' as field_name,'项目' as title,
	60 as width,130 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'jiu_kuan' as field,
	'去年旧款' as field_name,'去年旧款' as title,
	60 as width,190as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'yf1' as field,
	'1月应付' as field_name,'1月应付' as title,
	60 as width,200 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'m1' as field,
	'1月实付' as field_name,'1月实付' as title,
	60 as width,201 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'yf2' as field,
	'2月应付' as field_name,'2月应付' as title,
	60 as width,202 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'m2' as field,
	'2月实付' as field_name,'2月实付' as title,
	60 as width,203 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'yf3' as field,
	'3月应付' as field_name,'3月应付' as title,
	60 as width,204 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'m3' as field,
	'3月实付' as field_name,'3月实付' as title,
	60 as width,205 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'yf4' as field,
	'4月应付' as field_name,'4月应付' as title,
	60 as width,206 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'m4' as field,
	'4月实付' as field_name,'4月实付' as title,
	60 as width,207 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'yf5' as field,
	'5月应付' as field_name,'5月应付' as title,
	60 as width,208 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'m5' as field,
	'5月实付' as field_name,'5月实付' as title,
	60 as width,209 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'yf6' as field,
	'6月应付' as field_name,'6月应付' as title,
	60 as width,210 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'m6' as field,
	'6月实付' as field_name,'6月实付' as title,
	60 as width,211 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'yf7' as field,
	'7月应付' as field_name,'7月应付' as title,
	60 as width,212 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'m7' as field,
	'7月实付' as field_name,'7月实付' as title,
	60 as width,213 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'yf8' as field,
	'8月应付' as field_name,'8月应付' as title,
	60 as width,214 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'m8' as field,
	'8月实付' as field_name,'8月实付' as title,
	60 as width,215 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'yf9' as field,
	'9月应付' as field_name,'9月应付' as title,
	60 as width,216 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'m9' as field,
	'9月实付' as field_name,'9月实付' as title,
	60 as width,217 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'yf10' as field,
	'10月应付' as field_name,'10月应付' as title,
	60 as width,218 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'m10' as field,
	'10月实付' as field_name,'10月实付' as title,
	60 as width,219 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'yf11' as field,
	'11月应付' as field_name,'11月应付' as title,
	60 as width,220 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'m11' as field,
	'11月实付' as field_name,'11月实付' as title,
	60 as width,221 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'yf12' as field,
	'12月应付' as field_name,'12月应付' as title,
	60 as width,222 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'m12' as field,
	'12月实付' as field_name,'12月实付' as title,
	60 as width,223 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'bn_yf_kuan_he_ji' as field,
	'本年应付款' as field_name,'本年应付款' as title,
	70 as width,192 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'yf_kuan_he_ji' as field,
	'应付款' as field_name,'应付款' as title,
	70 as width,260 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;
	
	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'sf_kuan_he_ji' as field,
	'实付款' as field_name,'实付款' as title,
	70 as width,260 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_BanZu_List' as module,'qian_kuan' as field,
	'欠款金额' as field_name,'欠款金额' as title,
	70 as width,260 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;
end
/**/GO


--插入[应付]列表界面格式
--delete System_ModuleFormat where module='Ling_YingFu_List'
if(select count(1) from System_ModuleFormat where module='Ling_YingFu_List' and field='yf_id')=0
begin
	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_List' as module,'yf_id' as field,
	'ID' as field_name,'ID' as title,
	120 as width,100 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_List' as module,'add_date' as field,
	'发生日期' as field_name,'发生日期' as title,
	70 as width,110 as sort,1 as show,0 as hidden,0 as sum_field,'date' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_List' as module,'cus_id' as field,
	'工地ID' as field_name,'工地ID' as title,
	120 as width,140 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_List' as module,'cus_name' as field,
	'工地' as field_name,'工地' as title,
	100 as width,150 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_List' as module,'vd_id' as field,
	'供应商ID' as field_name,'供应商ID' as title,
	120 as width,160 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_List' as module,'vd_name' as field,
	'供应商' as field_name,'供应商' as title,
	100 as width,170 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_List' as module,'ele_id' as field,
	'员工ID' as field_name,'员工ID' as title,
	120 as width,180 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_List' as module,'ele_name' as field,
	'员工' as field_name,'员工' as title,
	60 as width,190 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_List' as module,'amount' as field,
	'应付金额' as field_name,'应付金额' as title,
	60 as width,200 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_List' as module,'cst_id' as field,
	'费用类型ID' as field_name,'费用类型ID' as title,
	120 as width,230 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_List' as module,'cst_name' as field,
	'费用类型' as field_name,'费用类型' as title,
	60 as width,240 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_List' as module,'digest' as field,
	'主要材料' as field_name,'主要材料' as title,
	80 as width,250 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_List' as module,'remark' as field,
	'备注' as field_name,'备注' as title,
	200 as width,260 as sort,1 as show,0 as hidden,0 as sum_field,'textarea' as type,1 as can_edit;
end
/**/GO

--插入[应付]列表界面格式
--delete System_ModuleFormat where module='Ling_YingFu_Input'
if(select count(1) from System_ModuleFormat where module='Ling_YingFu_Input' and field='yf_id')=0
begin
	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_Input' as module,'yf_id' as field,
	'ID' as field_name,'ID' as title,
	120 as width,100 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_Input' as module,'add_date' as field,
	'发生日期' as field_name,'发生日期' as title,
	120 as width,110 as sort,1 as show,0 as hidden,0 as sum_field,'date' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_Input' as module,'amount' as field,
	'应付金额' as field_name,'应付金额' as title,
	120 as width,140 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_Input' as module,'cus_id' as field,
	'工地ID' as field_name,'工地ID' as title,
	120 as width,150 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_Input' as module,'cus_name' as field,
	'工地' as field_name,'工地' as title,
	98 as width,160 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_Input' as module,'vd_id' as field,
	'供应商ID' as field_name,'供应商ID' as title,
	120 as width,170 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_Input' as module,'vd_name' as field,
	'供应商' as field_name,'供应商' as title,
	98 as width,180 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_Input' as module,'ele_id' as field,
	'员工ID' as field_name,'员工ID' as title,
	120 as width,190 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_Input' as module,'ele_name' as field,
	'员工' as field_name,'员工' as title,
	98 as width,200 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_Input' as module,'cst_id' as field,
	'费用类型ID' as field_name,'费用类型ID' as title,
	120 as width,210 as sort,0 as show,0 as hidden,0 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_Input' as module,'cst_name' as field,
	'费用类型' as field_name,'费用类型' as title,
	98 as width,220 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_Input' as module,'digest' as field,
	'主要材料' as field_name,'主要材料' as title,
	120 as width,230 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_YingFu_Input' as module,'remark' as field,
	'备注' as field_name,'备注' as title,
	200 as width,240 as sort,1 as show,0 as hidden,0 as sum_field,'textarea' as type,1 as can_edit;
end
/**/GO



--插入[供应商年帐目明细表]列表界面格式
--delete System_ModuleFormat where module='Ling_VendorYingFu_List'
if(select count(1) from System_ModuleFormat where module='Ling_VendorYingFu_List' and field='vd_name')=0
begin
	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'vd_name' as field,
	'供应商' as field_name,'供应商' as title,
	60 as width,100 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'cellphone' as field,
	'电话' as field_name,'电话' as title,
	80 as width,110 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'cus_name' as field,
	'工地' as field_name,'工地' as title,
	100 as width,120 as sort,1 as show,0 as hidden,0 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'jiu_kuan' as field,
	'去年旧款' as field_name,'去年旧款' as title,
	60 as width,190as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'yf1' as field,
	'1月应付' as field_name,'1月应付' as title,
	60 as width,200 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'m1' as field,
	'1月实付' as field_name,'1月实付' as title,
	60 as width,201 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'yf2' as field,
	'2月应付' as field_name,'2月应付' as title,
	60 as width,202 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'m2' as field,
	'2月实付' as field_name,'2月实付' as title,
	60 as width,203 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'yf3' as field,
	'3月应付' as field_name,'3月应付' as title,
	60 as width,204 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'m3' as field,
	'3月实付' as field_name,'3月实付' as title,
	60 as width,205 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'yf4' as field,
	'4月应付' as field_name,'4月应付' as title,
	60 as width,206 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'m4' as field,
	'4月实付' as field_name,'4月实付' as title,
	60 as width,207 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'yf5' as field,
	'5月应付' as field_name,'5月应付' as title,
	60 as width,208 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'m5' as field,
	'5月实付' as field_name,'5月实付' as title,
	60 as width,209 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'yf6' as field,
	'6月应付' as field_name,'6月应付' as title,
	60 as width,210 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'m6' as field,
	'6月实付' as field_name,'6月实付' as title,
	60 as width,211 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'yf7' as field,
	'7月应付' as field_name,'7月应付' as title,
	60 as width,212 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'m7' as field,
	'7月实付' as field_name,'7月实付' as title,
	60 as width,213 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'yf8' as field,
	'8月应付' as field_name,'8月应付' as title,
	60 as width,214 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'m8' as field,
	'8月实付' as field_name,'8月实付' as title,
	60 as width,215 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'yf9' as field,
	'9月应付' as field_name,'9月应付' as title,
	60 as width,216 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'m9' as field,
	'9月实付' as field_name,'9月实付' as title,
	60 as width,217 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'yf10' as field,
	'10月应付' as field_name,'10月应付' as title,
	60 as width,218 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'m10' as field,
	'10月实付' as field_name,'10月实付' as title,
	60 as width,219 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'yf11' as field,
	'11月应付' as field_name,'11月应付' as title,
	60 as width,220 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'m11' as field,
	'11月实付' as field_name,'11月实付' as title,
	60 as width,221 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'yf12' as field,
	'12月应付' as field_name,'12月应付' as title,
	60 as width,222 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'m12' as field,
	'12月实付' as field_name,'12月实付' as title,
	60 as width,223 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,1 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'bn_yf_kuan_he_ji' as field,
	'本年应付款' as field_name,'本年应付款' as title,
	70 as width,198 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'yf_kuan_he_ji' as field,
	'应付款' as field_name,'应付款' as title,
	70 as width,260 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;
	
	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'sf_kuan_he_ji' as field,
	'实付款' as field_name,'实付款' as title,
	70 as width,260 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;

	insert System_ModuleFormat(module,field,field_name,
	title,width,sort,show,hidden,sum_field,type,can_edit)
	select 'Ling_VendorYingFu_List' as module,'qian_kuan' as field,
	'欠款金额' as field_name,'欠款金额' as title,
	70 as width,260 as sort,1 as show,0 as hidden,1 as sum_field,'text' as type,0 as can_edit;
end
/**/GO

