﻿--delete System_Config;
--系统默认小数位
if (select count(1) from System_Config where cf_code='digit_quantity')=0
begin
	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro,hidden)
	select 'digit_unit_price' as cf_code,'单价小数位' as cf_name,'4' as cf_value,
	'Base' as category,'number' as cf_type,null as value_list,
	'指定单据中单价相关列的小数位' as cf_intro,1 as hidden;

	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro,hidden)
	select 'digit_quantity' as cf_code,'数量小数位' as cf_name,'4' as cf_value,
	'Base' as category,'number' as cf_type,null as value_list,
	'指定单据中数量相关列的小数位' as cf_intro,1 as hidden;

	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro,hidden)
	select 'digit_number' as cf_code,'件数小数位' as cf_name,'4' as cf_value,
	'Base' as category,'number' as cf_type,null as value_list,
	'指定单据中辅计量单位数量相关列的小数位' as cf_intro,1 as hidden;

	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro,hidden)
	select 'digit_exch' as cf_code,'换算率小数位' as cf_name,'4' as cf_value,
	'Base' as category,'number' as cf_type,null as value_list,
	'指定单据中换算率相关列的小数位' as cf_intro,1 as hidden;
end
/**/GO

if (select count(1) from System_Config where cf_code='over_order_quantity_sale')=0
begin
	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'account_name' as cf_code,'账套名称' as cf_name,'' as cf_value,
	'System' as category,'text' as cf_type,null as value_list,
	'可以是企业名称、门店名称、部门名称等' as cf_intro;
	
	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'over_order_quantity_sale' as cf_code,'是否可超销售订单发货' as cf_name,'0' as cf_value,
	'Sale' as category,'radio' as cf_type,'1,允许;0,禁止' as value_list,
	'发货单是否可超销售订单数量' as cf_intro;

	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'over_order_quantity_purchase' as cf_code,'是否可超采购订单入库' as cf_name,'0' as cf_value,
	'Purchase' as category,'radio' as cf_type,'1,允许;0,禁止' as value_list,
	'采购入库单是否可超采购订单数量' as cf_intro;

	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'sale_fahuo_verify_salesout' as cf_code,'发货单审核自动生成出库单' as cf_name,'1' as cf_value,
	'Sale' as category,'radio' as cf_type,'1,启用;0,关闭' as value_list,
	'启用后发货单审核立即生成销售出库单并扣减现存量' as cf_intro;
	
	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'purchase_in_verify_check_account' as cf_code,'采购入库单审核自动生成对账单' as cf_name,'1' as cf_value,
	'Purchase' as category,'radio' as cf_type,'1,启用;0,关闭' as value_list,
	'简化采购流程：采购订单->入库单->付款，省去了采购对账环节' as cf_intro;

	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'sales_out_verify_check_account' as cf_code,'销售出库单审核自动生成对账单' as cf_name,'1' as cf_value,
	'Sale' as category,'radio' as cf_type,'1,启用;0,关闭' as value_list,
	'简化销售流程：销售订单->发货单->销售出库单->收款，省去了销售对账环节' as cf_intro;

	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'sale_employee_auth' as cf_code,'销售模块启用业务员权限控制' as cf_name,'0' as cf_value,
	'Sale' as category,'radio' as cf_type,'1,启用;0,关闭' as value_list,
	'启用后业务员只允许查看自己的客户、订单、发货单，可设置业务员上级主管' as cf_intro;
	
	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'stock_input_iotype' as cf_code,'仓库进出时收发类型是否必须填写' as cf_name,'0' as cf_value,
	'Stock' as category,'radio' as cf_type,'1,必填;0,可选' as value_list,
	'填写后才能出收发类型汇总表' as cf_intro;
end
/**/GO

if (select count(1) from System_Config where cf_code='order_can_see_cus_inv_sale')=0
begin
	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'order_can_see_cus_inv_sale' as cf_code,'销售订单只显示客户指定的存货' as cf_name,'0' as cf_value,
	'Sale' as category,'radio' as cf_type,'1,启用;0,关闭' as value_list,
	'在客户产品表可为客户指定存货' as cf_intro;
end
/**/GO

/*
if (select count(1) from System_Config where cf_code='phone_sale_customer')=0
begin
	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'phone_sale_customer' as cf_code,'销售订单默认客户编码' as cf_name,'' as cf_value,
	'Phone' as category,'text' as cf_type,null as value_list,
	'手机下销售订单、发货单时默认客户编码' as cf_intro;
	
	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'phone_sale_employee' as cf_code,'销售订单默认业务员编码' as cf_name,'' as cf_value,
	'Phone' as category,'text' as cf_type,null as value_list,
	'手机下销售订单、发货单时默认业务员编码' as cf_intro;
	
	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'phone_sale_saletype' as cf_code,'销售订单默认销售类型编码' as cf_name,'' as cf_value,
	'Phone' as category,'text' as cf_type,null as value_list,
	'手机下销售订单、发货单时默认销售类型编码' as cf_intro;
end
*/
/**/GO


/*
	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'stock_over_plan_out' as cf_code,'是否可超生产工单领料' as cf_name,'0' as cf_value,
	'Stock' as category,'radio' as cf_type,'1,允许;0,禁止' as value_list,
	'领料单是否可超生产加工单计划数量' as cf_intro;

	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'stock_over_plan_in' as cf_code,'是否可超生产工单入库' as cf_name,'0' as cf_value,
	'Stock' as category,'radio' as cf_type,'1,允许;0,禁止' as value_list,
	'产成品入库单是否可超生产加工单计划数量' as cf_intro;
*/

--自由项的显示标题
if (select count(1) from System_Config where cf_code='free1_title')=0
begin
	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'free1_title' as cf_code,'自由项1' as cf_name,'' as cf_value,
	'Base' as category,'text' as cf_type,null as value_list,
	'自由项1的显示标题' as cf_intro;

	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'free2_title' as cf_code,'自由项2' as cf_name,'' as cf_value,
	'Base' as category,'text' as cf_type,null as value_list,
	'自由项2的显示标题' as cf_intro;
end
/**/GO


--初始化系统支持的计价方式
if(select count(1) from Base_ValuationMethod)=0
begin
	insert Base_ValuationMethod(vm_id,vm_name)
	select 1,'全月平均法';
end
/**/GO
--初始化基本单据类型
if(select count(1) from Base_OrderType where ot_code='1')=0
begin
	insert Base_OrderType(ot_code,ot_name)
	select '1','其它入库单'
	union all
	select '2','其它出库单'
	union all
	select '3','采购入库单'
	union all
	select '4','材料出库单'
	union all
	select '5','成品入库单'
	union all
	select '6','销售出库单'
end
/**/GO

if(select count(1) from Base_IOType)=0
  and (select COUNT(*) from System_Version)=0
begin
	insert Base_IOType(iot_code,iot_name,iot_flag,parent_id,layer)
	select '1','所有入库',1,0,1;

	declare @p_iot_id int;
	select @p_iot_id=iot_id from Base_IOType where iot_name='所有入库';

	insert Base_IOType(iot_code,iot_name,iot_flag,parent_id,layer)
	select '101','采购入库',1,@p_iot_id,2;
	
	--insert Base_IOType(iot_code,iot_name,iot_flag,parent_id,layer)
	--select '102','产成品入库',1,@p_iot_id,2;

	insert Base_IOType(iot_code,iot_name,iot_flag,parent_id,layer)
	select '103','盘盈入库',1,@p_iot_id,2;
	
  insert Base_IOType(iot_code,iot_name,iot_flag,parent_id,layer)
	select '104','调拨入库',1,@p_iot_id,2;

	insert Base_IOType(iot_code,iot_name,iot_flag,parent_id,layer)
	select '105','其它入库',1,@p_iot_id,2;

	insert Base_IOType(iot_code,iot_name,iot_flag,parent_id,layer)
	select '106','采购退货',1,@p_iot_id,2;
	
	insert Base_IOType(iot_code,iot_name,iot_flag,parent_id,layer)
	select '2','所有出库',0,0,1;

	select @p_iot_id=iot_id from Base_IOType where iot_name='所有出库';

	insert Base_IOType(iot_code,iot_name,iot_flag,parent_id,layer)
	select '201','销售出库',0,@p_iot_id,2;

	--insert Base_IOType(iot_code,iot_name,iot_flag,parent_id,layer)
	--select '202','领料出库',0,@p_iot_id,2;

	insert Base_IOType(iot_code,iot_name,iot_flag,parent_id,layer)
	select '203','盘亏出库',0,@p_iot_id,2;
	
	insert Base_IOType(iot_code,iot_name,iot_flag,parent_id,layer)
	select '204','调拨出库',0,@p_iot_id,2;
	
	insert Base_IOType(iot_code,iot_name,iot_flag,parent_id,layer)
	select '205','其它出库',0,@p_iot_id,2;
	
	insert Base_IOType(iot_code,iot_name,iot_flag,parent_id,layer)
	select '206','销售退货',0,@p_iot_id,2;
end
/**/GO

--初始化币种
if(select count(1) from Base_Currency)=0
  and (select COUNT(*) from System_Version)=0
begin
	insert Base_Currency(crc_code,crc_name,is_standard)
	select 'RMB','人民币',1
end
/**/GO

--初始化采购类型
if(select count(1) from Base_PurchaseType)=0
  and (select COUNT(*) from System_Version)=0
begin
	insert Base_PurchaseType(pt_code,pt_name,is_default)
	select 'CG','普通采购',1
end
/**/GO
--初始化销售类型
if(select count(1) from Base_SaleType)=0
  and (select COUNT(*) from System_Version)=0
begin
	insert Base_SaleType(st_code,st_name,is_default)
	select 'XS','普通销售',1
end
/**/GO

--初始化结算方式
if(select count(1) from Base_SettleStyle)=0
  and (select COUNT(*) from System_Version)=0
begin
	insert Base_SettleStyle(ss_code,ss_name,is_stop,is_default)
	select 'XJ','现金',0,1
	union all
	select 'ZZ','转帐',0,0
end
/**/GO

--增加默认核销类型
if(select COUNT(*) from ARAP_CancelType)=0
begin
	insert into ARAP_CancelType(cl_type,cl_type_name)
	select 1,'收款'
	union all
	select 2,'付款'
	union all
	select 3,'预收冲应收'
	union all
	select 4,'预付冲应付'
end
/**/GO

--select * from Base_RunningNumberRule
--销售订单流水号
if(select count(1) from Base_RunningNumberRule where module_code='Sale_SalesOrder')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'Sale_SalesOrder','manual' as rule1,'XS' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

--增加销售订单流水号前缀
if(select count(1) from Base_RunningNumberPrefix where module_code='Sale_SalesOrder')=0
begin
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Sale_SalesOrder' as module_code,'cus_code' as prefix_code,'客户' as prefix_name,'Base_Customer' as link_table;
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Sale_SalesOrder' as module_code,'st_code' as prefix_code,'销售类型' as prefix_name,'Base_SaleType' as link_table;
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Sale_SalesOrder' as module_code,'dep_code' as prefix_code,'部门' as prefix_name,'Base_Department' as link_table;
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Sale_SalesOrder' as module_code,'ele_code' as prefix_code,'业务员' as prefix_name,'Base_Employee' as link_table;
end
/**/GO
--发货单流水号
if(select count(1) from Base_RunningNumberRule where module_code='Sale_DeliveryOrder')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'Sale_DeliveryOrder','manual' as rule1,'FH' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

--增加发货单流水号前缀
if(select count(1) from Base_RunningNumberPrefix where module_code='Sale_DeliveryOrder')=0
begin
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Sale_DeliveryOrder' as module_code,'cus_code' as prefix_code,'客户' as prefix_name,'Base_Customer' as link_table;
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Sale_DeliveryOrder' as module_code,'st_code' as prefix_code,'销售类型' as prefix_name,'Base_SaleType' as link_table;
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Sale_DeliveryOrder' as module_code,'dep_code' as prefix_code,'部门' as prefix_name,'Base_Department' as link_table;
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Sale_DeliveryOrder' as module_code,'ele_code' as prefix_code,'业务员' as prefix_name,'Base_Employee' as link_table;
end
/**/GO

--销售出库单流水号
if(select count(1) from Base_RunningNumberRule where module_code='Sale_SalesOut')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'Sale_SalesOut','manual' as rule1,'SC' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

--增加销售出库单流水号前缀
if(select count(1) from Base_RunningNumberPrefix where module_code='Sale_SalesOut')=0
begin
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Sale_SalesOut' as module_code,'st_code' as prefix_code,'收发类型' as prefix_name,'Base_SaleType' as link_table;
end
/**/GO

--销售对账单流水号
if(select count(1) from Base_RunningNumberRule where module_code='Sale_CheckAccount')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'Sale_CheckAccount','manual' as rule1,'XSDZ' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

--增加销售对账单流水号前缀
if(select count(1) from Base_RunningNumberPrefix where module_code='Sale_CheckAccount')=0
begin
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Sale_CheckAccount' as module_code,'cus_code' as prefix_code,'客户' as prefix_name,'Base_Customer' as link_table;
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Sale_CheckAccount' as module_code,'ele_code' as prefix_code,'业务员' as prefix_name,'Base_Employee' as link_table;
end
/**/GO
--采购对账单流水号
if(select count(1) from Base_RunningNumberRule where module_code='Purchase_CheckAccount')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'Purchase_CheckAccount','manual' as rule1,'CGDZ' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

--增加采购对账单流水号前缀
if(select count(1) from Base_RunningNumberPrefix where module_code='Purchase_CheckAccount')=0
begin
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Purchase_CheckAccount' as module_code,'vd_code' as prefix_code,'供应商' as prefix_name,'Base_Customer' as link_table;
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Purchase_CheckAccount' as module_code,'ele_code' as prefix_code,'业务员' as prefix_name,'Base_Employee' as link_table;
end
/**/GO


--采购订单流水号
if(select count(1) from Base_RunningNumberRule where module_code='Purchase_PurchaseOrder')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'Purchase_PurchaseOrder','manual' as rule1,'CG' as rule1_value,'[ele_code]' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

--增加采购订单流水号前缀
if(select count(1) from Base_RunningNumberPrefix where module_code='Purchase_PurchaseOrder')=0
begin
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Purchase_PurchaseOrder' as module_code,'pt_code' as prefix_code,'采购类型' as prefix_name,'Base_PurchaseType' as link_table;
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Purchase_PurchaseOrder' as module_code,'dep_code' as prefix_code,'部门' as prefix_name,'Base_Department' as link_table;
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Purchase_PurchaseOrder' as module_code,'ele_code' as prefix_code,'业务员' as prefix_name,'Base_Employee' as link_table;
end
/**/GO

--其它入库单流水号
if(select count(1) from Base_RunningNumberRule where module_code='Stock_OtherIn')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'Stock_OtherIn','manual' as rule1,'QTRK' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

--增加其它入库单流水号前缀
if(select count(1) from Base_RunningNumberPrefix where module_code='Stock_OtherIn')=0
begin
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Stock_OtherIn' as module_code,'iot_code' as prefix_code,'收发类型' as prefix_name,'Base_IOType' as link_table;
end
/**/GO

--其它出库单流水号
if(select count(1) from Base_RunningNumberRule where module_code='Stock_OtherOut')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'Stock_OtherOut','manual' as rule1,'QTCK' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO
--增加其它出库单流水号前缀
if(select count(1) from Base_RunningNumberPrefix where module_code='Stock_OtherOut')=0
begin
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Stock_OtherOut' as module_code,'iot_code' as prefix_code,'收发类型' as prefix_name,'Base_IOType' as link_table;
end
/**/GO

--采购入库单流水号
if(select count(1) from Base_RunningNumberRule where module_code='Purchase_PurchaseIn')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'Purchase_PurchaseIn','manual' as rule1,'CGRK' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO
--增加采购入库单流水号前缀
if(select count(1) from Base_RunningNumberPrefix where module_code='Purchase_PurchaseIn')=0
begin
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Purchase_PurchaseIn' as module_code,'iot_code' as prefix_code,'收发类型' as prefix_name,'Base_IOType' as link_table;
end
/**/GO


--材料出库单流水号
if(select count(1) from Base_RunningNumberRule where module_code='Stock_MaterialOut')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'Stock_MaterialOut','manual' as rule1,'CLCK' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

--增加材料出库单流水号前缀
if(select count(1) from Base_RunningNumberPrefix where module_code='Stock_MaterialOut')=0
begin
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Stock_MaterialOut' as module_code,'iot_code' as prefix_code,'收发类型' as prefix_name,'Base_IOType' as link_table;
end
/**/GO

--其它入库单流水号
if(select count(1) from Base_RunningNumberRule where module_code='Stock_ProductIn')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'Stock_ProductIn','manual' as rule1,'CPRK' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

--增加其它入库单流水号前缀
if(select count(1) from Base_RunningNumberPrefix where module_code='Stock_ProductIn')=0
begin
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'Stock_ProductIn' as module_code,'iot_code' as prefix_code,'收发类型' as prefix_name,'Base_IOType' as link_table;
end
/**/GO

--生产加工单流水号
/*
if(select count(1) from Base_RunningNumberRule where module_code='Plan_PMC')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'Plan_PMC','manual' as rule1,'GD' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
*/
/**/GO

--调拨单流水号
if(select count(1) from Base_RunningNumberRule where module_code='Stock_Transfer')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'Stock_Transfer','manual' as rule1,'DB' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

--盘点单流水号
if(select count(1) from Base_RunningNumberRule where module_code='Stock_StockCount')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'Stock_StockCount','manual' as rule1,'PD' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

--增加打印模板-销售订单
if((select count(1) from System_PrintTemplate where is_system=1 and module='Sale_SalesOrder' and template_name='销售订单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Sale_SalesOrder','销售订单',1,'../GrfFile/Sale_SalesOrder.grf';
end
/**/GO
--增加打印模板-销售订单明细表
if((select count(1) from System_PrintTemplate where is_system=1 and module='Sale_Report_SalesOrder_Details' and template_name='销售订单明细表')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Sale_Report_SalesOrder_Details','销售订单明细表',1,'../GrfFile/Sale_SalesOrder_Details.grf';
end
/**/GO

--增加打印模板-发货单
if((select count(1) from System_PrintTemplate where is_system=1 and module='Sale_DeliveryOrder' and template_name='发货单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Sale_DeliveryOrder','发货单',1,'../GrfFile/Sale_DeliveryOrder.grf';
end
/**/GO
--增加打印模板-发货单明细表
if((select count(1) from System_PrintTemplate where is_system=1 and module='Sale_Report_DeliveryOrder_Details' and template_name='发货单明细表')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Sale_Report_DeliveryOrder_Details','发货单明细表',1,'../GrfFile/Sale_DeliveryOrder_Details.grf';
end
/**/GO

--增加打印模板-销售出库单
if((select count(1) from System_PrintTemplate where is_system=1 and module='Sale_SalesOut' and template_name='销售出库单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Sale_SalesOut','销售出库单',1,'../GrfFile/Sale_SalesOut.grf';
end
/**/GO
--增加打印模板-销售出库单明细表
if((select count(1) from System_PrintTemplate where is_system=1 and module='Sale_Report_SalesOut_Details' and template_name='销售出库单明细表')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Sale_Report_SalesOut_Details','销售出库单明细表',1,'../GrfFile/Sale_SalesOut_Details.grf';
end
/**/GO
--增加打印模板-销售对账单
if((select count(1) from System_PrintTemplate where is_system=1 and module='Sale_CheckAccount' and template_name='销售对账单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Sale_CheckAccount','销售对账单',1,'../GrfFile/Sale_CheckAccount.grf';
end
/**/GO
--增加打印模板-采购对账单
if((select count(1) from System_PrintTemplate where is_system=1 and module='Purchase_CheckAccount' and template_name='采购对账单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Purchase_CheckAccount','采购对账单',1,'../GrfFile/Purchase_CheckAccount.grf';
end
/**/GO
--增加打印模板-采购订单
if((select count(1) from System_PrintTemplate where is_system=1 and module='Purchase_PurchaseOrder' and template_name='采购订单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Purchase_PurchaseOrder','采购订单',1,'../GrfFile/Purchase_PurchaseOrder.grf';
end
/**/GO
--增加打印模板-采购订单明细表
if((select count(1) from System_PrintTemplate where is_system=1 and module='Purchase_Report_PurchaseOrder_Details' and template_name='采购订单明细表')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Purchase_Report_PurchaseOrder_Details','采购订单明细表',1,'../GrfFile/Purchase_PurchaseOrder_Details.grf';
end
/**/GO

--增加打印模板-采购入库单
if((select count(1) from System_PrintTemplate where is_system=1 and module='Purchase_PurchaseIn' and template_name='采购入库单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Purchase_PurchaseIn','采购入库单',1,'../GrfFile/Purchase_PurchaseIn.grf';
end
/**/GO
--增加打印模板-其它入库单
if((select count(1) from System_PrintTemplate where is_system=1 and module='Stock_OtherIn' and template_name='其它入库单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Stock_OtherIn','其它入库单',1,'../GrfFile/Stock_OtherIn.grf';
end
/**/GO
--增加打印模板-产成品入库单
if((select count(1) from System_PrintTemplate where is_system=1 and module='Stock_ProductIn' and template_name='产成品入库单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Stock_ProductIn','产成品入库单',1,'../GrfFile/Stock_ProductIn.grf';
end
/**/GO
--增加打印模板-其它出库单
if((select count(1) from System_PrintTemplate where is_system=1 and module='Stock_OtherOut' and template_name='其它出库单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Stock_OtherOut','其它出库单',1,'../GrfFile/Stock_OtherOut.grf';
end
/**/GO
--增加打印模板-材料出库单
if((select count(1) from System_PrintTemplate where is_system=1 and module='Stock_MaterialOut' and template_name='材料出库单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Stock_MaterialOut','材料出库单',1,'../GrfFile/Stock_MaterialOut.grf';
end
/**/GO

--增加打印模板-调拨单
if((select count(1) from System_PrintTemplate where is_system=1 and module='Stock_Transfer' and template_name='调拨单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Stock_Transfer','调拨单',1,'../GrfFile/Stock_Transfer.grf';
end
/**/GO
--增加打印模板-盘点单
if((select count(1) from System_PrintTemplate where is_system=1 and module='Stock_StockCount' and template_name='盘点单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Stock_StockCount','盘点单',1,'../GrfFile/Stock_StockCount.grf';
end
/**/GO
--增加打印模板-收款单
if((select count(1) from System_PrintTemplate where is_system=1 and module='ARAP_ShouKuan' and template_name='收款单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'ARAP_ShouKuan','收款单',1,'../GrfFile/ARAP_ShouKuan.grf';
end
/**/GO
 
--增加打印模板-付款单
if((select count(1) from System_PrintTemplate where is_system=1 and module='ARAP_FuKuan' and template_name='付款单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'ARAP_FuKuan','付款单',1,'../GrfFile/ARAP_FuKuan.grf';
end
/**/GO
--增加打印模板-其它应收单
if((select count(1) from System_PrintTemplate where is_system=1 and module='ARAP_OtherRP_AR' and template_name='其它应收单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'ARAP_OtherRP_AR','其它应收单',1,'../GrfFile/ARAP_OtherRP_AR.grf';
end
/**/GO
--增加打印模板-其它应付单
if((select count(1) from System_PrintTemplate where is_system=1 and module='ARAP_OtherRP_AP' and template_name='其它应付单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'ARAP_OtherRP_AP','其它应付单',1,'../GrfFile/ARAP_OtherRP_AP.grf';
end
/**/GO
--增加打印模板-现存量查询
if((select count(1) from System_PrintTemplate where is_system=1 and module='Stock_OnHand' and template_name='现存量查询')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Stock_OnHand','现存量查询',1,'../GrfFile/Stock_OnHand.grf';
end
/**/GO

--增加打印模板-采购入库单明细表
if((select count(1) from System_PrintTemplate where is_system=1 and module='Purchase_Report_PurchaseIn_Details' and template_name='采购入库单明细表')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Purchase_Report_PurchaseIn_Details','采购入库单明细表',1,'../GrfFile/Purchase_PurchaseIn_Details.grf';
end
/**/GO
--增加打印模板-其它入库单明细表
if((select count(1) from System_PrintTemplate where is_system=1 and module='Stock_Report_OtherIn_Details' and template_name='其它入库单明细表')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Stock_Report_OtherIn_Details','其它入库单明细表',1,'../GrfFile/Stock_OtherIn_Details.grf';
end
/**/GO

--增加打印模板-其它出库单明细表
if((select count(1) from System_PrintTemplate where is_system=1 and module='Stock_Report_OtherOut_Details' and template_name='其它出库单明细表')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Stock_Report_OtherOut_Details','其它出库单明细表',1,'../GrfFile/Stock_OtherOut_Details.grf';
end
/**/GO
/*
--增加打印模板-物料清单
if((select count(1) from System_PrintTemplate where is_system=1 and module='Base_BOM' and template_name='物料清单')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Base_BOM','物料清单',1,'../GrfFile/Base_BOM.grf';
end
*/
/**/GO
/*
--增加打印模板-物料清单列表
if((select count(1) from System_PrintTemplate where is_system=1 and module='Base_BOM_List' and template_name='物料清单列表')=0)
begin
	insert System_PrintTemplate(module,template_name,is_system,grf_file)
	select 'Base_BOM_List','物料清单列表',1,'../GrfFile/Base_BOM_List.grf';
end
*/
/**/GO

--收款单流水号
if(select count(1) from Base_RunningNumberRule where module_code='ARAP_ShouKuan')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'ARAP_ShouKuan','manual' as rule1,'SK' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

--增加收款单流水号前缀
if(select count(1) from Base_RunningNumberPrefix where module_code='ARAP_ShouKuan')=0
begin
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'ARAP_ShouKuan' as module_code,'cus_code' as prefix_code,'客户' as prefix_name,'Base_Customer' as link_table;
end
/**/GO

--付款单流水号
if(select count(1) from Base_RunningNumberRule where module_code='ARAP_FuKuan')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'ARAP_FuKuan','manual' as rule1,'FK' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

--增加付款单流水号前缀
if(select count(1) from Base_RunningNumberPrefix where module_code='ARAP_FuKuan')=0
begin
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'ARAP_FuKuan' as module_code,'vd_code' as prefix_code,'供应商' as prefix_name,'Base_Vendor' as link_table;
end
/**/GO


--其它应收单流水号
if(select count(1) from Base_RunningNumberRule where module_code='ARAP_OtherRP_AR')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'ARAP_OtherRP_AR','manual' as rule1,'YS' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

--增加其它应收单流水号前缀
if(select count(1) from Base_RunningNumberPrefix where module_code='ARAP_OtherRP_AR')=0
begin
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'ARAP_OtherRP_AR' as module_code,'cus_code' as prefix_code,'客户' as prefix_name,'Base_Customer' as link_table;
end
/**/GO


--其它应付单流水号
if(select count(1) from Base_RunningNumberRule where module_code='ARAP_OtherRP_AP')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'ARAP_OtherRP_AP','manual' as rule1,'YF' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

--增加其它应付单流水号前缀
if(select count(1) from Base_RunningNumberPrefix where module_code='ARAP_OtherRP_AP')=0
begin
	insert into Base_RunningNumberPrefix(module_code,prefix_code,prefix_name,link_table)
	select 'ARAP_OtherRP_AP' as module_code,'vd_code' as prefix_code,'供应商' as prefix_name,'Base_Vendor' as link_table;
end
/**/GO
--核销单流水号
if(select count(1) from Base_RunningNumberRule where module_code='ARAP_CancelOrder')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'ARAP_CancelOrder','manual' as rule1,'HX' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,5 as length;
end
/**/GO

/*自定义报表过滤框*/
--delete System_XReportFilter

if(select COUNT(*) from System_XReportFilter where xf_code='cus_code')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'cus_code','客户','
	select top 1000000000 cus_code as xf_code,cus_name as xf_name from Base_Customer order by cus_code asc';
end
/**/GO

if(select COUNT(*) from System_XReportFilter where xf_code='vd_code')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'vd_code','供应商','
	select top 1000000000 vd_code as xf_code,vd_name as xf_name from Base_Vendor order by vd_code asc';
end
/**/GO
if(select COUNT(*) from System_XReportFilter where xf_code='wh_code')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'wh_code','仓库','
	select top 1000000000 wh_code as xf_code,wh_name as xf_name from Base_Customer order by wh_code asc';
end
/**/GO
if(select COUNT(*) from System_XReportFilter where xf_code='ic_code')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'ic_code','存货分类','
	select top 1000000000 ic_code as xf_code,ic_name as xf_name from Base_InventoryClass order by ic_code asc';
end
/**/GO
if(select COUNT(*) from System_XReportFilter where xf_code='i_code')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'i_code','存货','
	select top 1000000000 i_code as xf_code,i_name as xf_name from Base_Inventory order by i_code asc';
end
/**/GO
if(select COUNT(*) from System_XReportFilter where xf_code='dep_code')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'dep_code','部门','
	select top 1000000000 dep_code as xf_code,dep_name as xf_name from Base_Department order by dep_name asc';
end
/**/GO

if(select COUNT(*) from System_XReportFilter where xf_code='ele_code')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'ele_code','员工','
	select top 1000000000 ele_code as xf_code,ele_name as xf_name from Base_Employee order by ele_name asc';
end
/**/GO
if(select COUNT(*) from System_XReportFilter where xf_code='is_verify')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'is_verify','审核状态','
	select ''0'' as xf_code,''未审核'' as xf_name
	union all
	select ''1'' as xf_code,''已审核'' as xf_namex';
end
/**/GO
if(select COUNT(*) from System_XReportFilter where xf_code='iot_code')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'iot_code','收发类型','
	select top 1000000000 iot_code as xf_code,iot_name as xf_name from Base_IOType order by iot_code asc';
end
/**/GO
if(select COUNT(*) from System_XReportFilter where xf_code='iot_code_in')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'iot_code_in','入库类型','
	select top 1000000000 iot_code as xf_code,iot_name as xf_name from Base_IOType where iot_flag=1 order by iot_code asc';
end
/**/GO

if(select COUNT(*) from System_XReportFilter where xf_code='iot_code_out')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'iot_code_out','出库类型','
	select top 1000000000 iot_code as xf_code,iot_name as xf_name from Base_IOType where iot_flag=0 order by iot_code asc';
end
/**/GO
if(select COUNT(*) from System_XReportFilter where xf_code='crc_code')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'crc_code','币种','
	select crc_code as xf_code,crc_name as xf_name from Base_Currency order by crc_code asc';
end
/**/GO
if(select COUNT(*) from System_XReportFilter where xf_code='st_code')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'st_code','销售类型','
	select top 1000000000 st_code as xf_code,st_name as xf_name from Base_SaleType order by st_code asc';
end
/**/GO
if(select COUNT(*) from System_XReportFilter where xf_code='pt_code')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'pt_code','采购类型','
	select top 1000000000 pt_code as xf_code,pt_name as xf_name from Base_PurchaseType order by pt_code asc';
end
/**/GO
if(select COUNT(*) from System_XReportFilter where xf_code='ss_code')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'ss_code','结算方式','
	select top 1000000000 ss_code as xf_code,ss_name as xf_name from Base_SettleStyle order by ss_code asc';
end
/**/GO
if(select COUNT(*) from System_XReportFilter where xf_code='ac_code')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'ac_code','结算账户','
	select top 1000000000 ac_code as xf_code,ac_name as xf_name from Base_Account order by ac_code asc';
end
/**/GO
if(select COUNT(*) from System_XReportFilter where xf_code='cc_code')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'cc_code','客户分类','
	select top 1000000000 cc_code as xf_code,cc_name as xf_name from Base_CustomerClass order by cc_code asc';
end
/**/GO
if(select COUNT(*) from System_XReportFilter where xf_code='vc_code')=0
begin 
	insert System_XReportFilter(xf_code,xf_name,xf_sql)
	select 'vc_code','供应商分类','
	select top 1000000000 vc_code as xf_code,vc_name as xf_name from Base_VendorClass order by vc_code asc';
end
/**/GO

--delete System_ModuleScript where ms_code='SalesOrders_Edit_JavaScript';
if(select COUNT(*) from System_ModuleScript where ms_code='SalesOrders_Edit_JavaScript')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'SalesOrders_Edit_JavaScript' as ms_code,
	'销售订单子表页面JS脚本' as ms_name,'JavaScript' as ms_type,
	'录入产品页面加载后执行' as remark,
	'
	/*
	//改数量时，让金额=数量x4，同时保留2位小数
	$F(''quantity'').onchange = function(){
		$F(''total_price'').value = JSRound($F(''quantity'').value*4,2);
	}*/' as script;
end
/**/GO
--delete System_ModuleScript where ms_code='DeliveryOrders_Edit_JavaScript';
if(select COUNT(*) from System_ModuleScript where ms_code='DeliveryOrders_Edit_JavaScript')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'DeliveryOrders_Edit_JavaScript' as ms_code,
	'发货单子表页面JS脚本' as ms_name,'JavaScript' as ms_type,'录入产品页面加载后执行' as remark,
	'
	/*
	//改数量时，让金额=数量x2
	$F(''quantity'').onchange = function(){
		$F(''total_price'').value = $F(''quantity'').value*2;
	}*/' as script;
end
/**/GO
--delete System_ModuleScript where ms_code='PurchaseOrders_Edit_JavaScript';
if(select COUNT(*) from System_ModuleScript where ms_code='PurchaseOrders_Edit_JavaScript')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'PurchaseOrders_Edit_JavaScript' as ms_code,
	'采购订单子表页面JS脚本' as ms_name,'JavaScript' as ms_type,'录入产品页面加载后执行' as remark,
	'
	/*
	//改数量时，让金额=数量x2
	$F(''quantity'').onchange = function(){
		$F(''total_price'').value = $F(''quantity'').value*2;
	}*/' as script;
end
/**/GO
--delete System_ModuleScript where ms_code='SalesOrder_Main_JavaScript';
if(select COUNT(*) from System_ModuleScript where ms_code='SalesOrder_Main_JavaScript')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'SalesOrder_Main_JavaScript' as ms_code,
	'销售订单主表页面JS脚本' as ms_name,'JavaScript' as ms_type,
	'加载单据表头后执行' as remark,
	'
	/*
	//改表头数值自定义项1时，让自定义项3=自定义项1*自定义项2
	$F(''ndefine1'').onchange = function(){
		$F(''ndefine3'').value = $F(''ndefine1'').value*$F(''ndefine2'').value;
	}*/' as script;
end
/**/GO
--delete System_ModuleScript where ms_code='PurchaseOrder_Main_JavaScript';
if(select COUNT(*) from System_ModuleScript where ms_code='PurchaseOrder_Main_JavaScript')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'PurchaseOrder_Main_JavaScript' as ms_code,
	'采购订单主表页面JS脚本' as ms_name,'JavaScript' as ms_type,
	'加载单据表头后执行' as remark,
	'
	/*
	//改表头数值自定义项1时，让自定义项3=自定义项1*自定义项2
	$F(''ndefine1'').onchange = function(){
		$F(''ndefine3'').value = $F(''ndefine1'').value*$F(''ndefine2'').value;
	}*/' as script;
end
/**/GO

--delete System_ModuleScript where ms_code='DeliveryOrder_Main_JavaScript';
if(select COUNT(*) from System_ModuleScript where ms_code='DeliveryOrder_Main_JavaScript')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'DeliveryOrder_Main_JavaScript' as ms_code,
	'发货单主表页面JS脚本' as ms_name,'JavaScript' as ms_type,
	'加载单据表头后执行' as remark,
	'
	/*
	//改表头数值自定义项1时，让自定义项3=自定义项1*自定义项2
	$F(''ndefine1'').onchange = function(){
		$F(''ndefine3'').value = $F(''ndefine1'').value*$F(''ndefine2'').value;
	}*/' as script;
end
/**/GO

--delete System_ModuleScript where ms_code='PurchaseIn_Main_JavaScript';
if(select COUNT(*) from System_ModuleScript where ms_code='PurchaseIn_Main_JavaScript')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'PurchaseIn_Main_JavaScript' as ms_code,
	'采购入库单主表页面JS脚本' as ms_name,'JavaScript' as ms_type,
	'加载单据表头后执行' as remark,
	'
	/*
	if(action==''Add''){
		//如果是新增单据,让收发类型默认为[采购入库]
		$F(''iot_id'').value = ''2'';
		$F(''iot_name'').value = ''采购入库'';
	}
	*/' as script;
end
/**/GO

--delete System_ModuleScript where ms_code='StockCount_Main_JavaScript';
if(select COUNT(*) from System_ModuleScript where ms_code='StockCount_Main_JavaScript')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'StockCount_Main_JavaScript' as ms_code,
	'盘点单主表页面JS脚本' as ms_name,'JavaScript' as ms_type,
	'加载单据表头后执行' as remark,
	'
	/*
	//如果是新增单据
	if(action==''Add''){
		//让入库类型默认为[盘盈入库]
		$F(''iot_id_in'').value = ''4'';
		$F(''iot_name_in'').value = ''盘盈入库'';
		//让出库类型默认为[盘亏出库]
		$F(''iot_id_out'').value = ''10'';
		$F(''iot_name_out'').value = ''盘亏出库'';
	}
	*/' as script;
end
/**/GO

--delete System_ModuleScript where ms_code='Transfer_Main_JavaScript';
if(select COUNT(*) from System_ModuleScript where ms_code='Transfer_Main_JavaScript')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'Transfer_Main_JavaScript' as ms_code,
	'调拨单主表页面JS脚本' as ms_name,'JavaScript' as ms_type,
	'加载单据表头后执行' as remark,
	'
	/*
	//如果是新增单据
	if(action==''Add''){
		//让入库类型默认为[调拨入库]
		$F(''iot_id_in'').value = ''5'';
		$F(''iot_name_in'').value = ''调拨入库'';
		//让出库类型默认为[调拨出库]
		$F(''iot_id_out'').value = ''11'';
		$F(''iot_name_out'').value = ''调拨出库'';
	}
	*/' as script;
end
/**/GO

--delete System_ModuleScript where ms_code='SalesOut_Main_JavaScript';
if(select COUNT(*) from System_ModuleScript where ms_code='SalesOut_Main_JavaScript')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'SalesOut_Main_JavaScript' as ms_code,
	'销售出库单主表页面JS脚本' as ms_name,'JavaScript' as ms_type,
	'加载单据表头后执行' as remark,
	'
	/*
	//如果是新增单据
	if(action==''Add''){
		//让出库类型默认为[销售出库]
		$F(''iot_id'').value = ''8'';
		$F(''iot_name'').value = ''销售出库'';
	}
	*/' as script;
end
/**/GO
--delete System_ModuleScript where ms_code='SalesOuts_Edit_JavaScript';
if(select COUNT(*) from System_ModuleScript where ms_code='SalesOuts_Edit_JavaScript')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'SalesOuts_Edit_JavaScript' as ms_code,
	'销售出库单子表页面JS脚本' as ms_name,'JavaScript' as ms_type,
	'录入产品页面加载后执行' as remark,
	'
	/*
	//改数量时，让金额=数量x4，同时保留2位小数
	$F(''quantity'').onchange = function(){
		$F(''total_price'').value = JSRound($F(''quantity'').value*4,2);
	}*/' as script;
end
/**/GO
--delete System_ModuleScript where ms_code='PurchaseIns_Edit_JavaScript';
if(select COUNT(*) from System_ModuleScript where ms_code='PurchaseIns_Edit_JavaScript')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'PurchaseIns_Edit_JavaScript' as ms_code,
	'采购入库单子表页面JS脚本' as ms_name,'JavaScript' as ms_type,
	'录入产品页面加载后执行' as remark,
	'
	/*
	//改数量时，让金额=数量x4，同时保留2位小数
	$F(''quantity'').onchange = function(){
		$F(''total_price'').value = JSRound($F(''quantity'').value*4,2);
	}*/' as script;
end
/**/GO

--delete System_ModuleScript where ms_code='PurchaseIn_Verify';
if(select COUNT(*) from System_ModuleScript where ms_code='PurchaseIn_Verify')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'PurchaseIn_Verify' as ms_code,
	'采购入库单审核SQL脚本' as ms_name,'SQL' as ms_type,
	'审核后执行，可用变量@io_id' as remark,
	'
	/*
		--更新存货档案
		update Base_Inventory set 
		new_nat_unit_price=d.unit_price,--无税单价=>最新成本
		new_tax_unit_price=d.tax_unit_price--含税单价=>最新报价
		from Stock_InOuts d where d.io_id=@io_id
		and isnull(d.unit_price,0)>0
		and Base_Inventory.i_id=d.i_id
	*/' as script;
end
/**/GO

--delete System_ModuleScript where ms_code='PurchaseOrder_Verify';
if(select COUNT(*) from System_ModuleScript where ms_code='PurchaseOrder_Verify')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'PurchaseOrder_Verify' as ms_code,
	'采购订单审核SQL脚本' as ms_name,'SQL' as ms_type,
	'审核后执行，可用变量@po_id' as remark,
	'
	/*
		--更新存货档案
		update Base_Inventory set 
		new_nat_unit_price=d.nat_unit_price,--无税单价=>最新成本
		new_tax_unit_price=d.tax_unit_price--含税单价=>最新报价
		from Purchase_PurchaseOrders d where d.po_id=@po_id
		and isnull(d.tax_unit_price,0)>0
		and Base_Inventory.i_id=d.i_id
	*/' as script;
end
/**/GO

--delete System_ModuleScript where ms_code='SalesOrder_Verify';
if(select COUNT(*) from System_ModuleScript where ms_code='SalesOrder_Verify')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'SalesOrder_Verify' as ms_code,
	'销售订单审核SQL脚本' as ms_name,'SQL' as ms_type,
	'审核后执行，可用变量@so_id' as remark,
	'
	/*
		--把表头自定义项1带到表体自定义项1
		update Sale_SalesOrders set d_sdefine1=t.sdefine1
		from Sale_SalesOrder t where Sale_SalesOrders.so_id=t.so_id
		and Sale_SalesOrders.so_id=@so_id
	*/' as script;
end
/**/GO

--delete System_ModuleScript where ms_code='DeliveryOrder_Verify';
if(select COUNT(*) from System_ModuleScript where ms_code='DeliveryOrder_Verify')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'DeliveryOrder_Verify' as ms_code,
	'发货单审核SQL脚本' as ms_name,'SQL' as ms_type,
	'审核后执行，可用变量@do_id' as remark,
	'
	/*
		--把表头自定义项2设置为当产日期
		update Sale_DeliveryOrder set sdefine2=getdate() where do_id=@do_id
	*/' as script;
end
/**/GO

--delete System_ModuleScript where ms_code='SalesOut_Verify';
if(select COUNT(*) from System_ModuleScript where ms_code='SalesOut_Verify')=0
begin
	insert System_ModuleScript(ms_code,ms_name,ms_type,remark,script)
	select 'SalesOut_Verify' as ms_code,
	'销售出库单审核SQL脚本' as ms_name,'SQL' as ms_type,
	'审核后执行，可用变量@io_id' as remark,
	'
	/*
		--把表体数值自定义项3=数值自定义项1*数值自定义项2，并保留2位小数
		update Stock_InOuts set d_ndefine3=round(d_ndefine1*d_ndefine2,2) where io_id=@io_id
	*/' as script;
end
/**/GO

if (select count(1) from System_Config where cf_code='system_dep_auth')=0
begin
	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'system_dep_auth' as cf_code,'启用部门权限控制' as cf_name,'0' as cf_value,
	'System' as category,'radio' as cf_type,'1,启用;0,关闭' as value_list,
	'启用后只能查看授权部门的单据' as cf_intro;
end
/**/GO

if (select count(1) from System_Config where cf_code='system_wh_auth')=0
begin
	insert System_Config(cf_code,cf_name,cf_value,
	category,cf_type,value_list,cf_intro)
	select 'system_wh_auth' as cf_code,'启用仓库权限控制' as cf_name,'0' as cf_value,
	'System' as category,'radio' as cf_type,'1,启用;0,关闭' as value_list,
	'启用后只能查看授权仓库的单据' as cf_intro;
end
/**/GO

--促销套餐流水号
if(select count(1) from Base_RunningNumberRule where module_code='Sale_GoodsCombo')=0
begin
	insert Base_RunningNumberRule(module_code,rule1,rule1_value,rule2,rule2_value,rule3,rule3_value,length)
	select 'Sale_GoodsCombo','manual' as rule1,'TC' as rule1_value,'' as rule2,'' as rule2_value,
	'date' as rule3,'[year][month]' as rule3_value,4 as length;
end
/**/GO

--更新版本号
if (select COUNT(*) from System_Version)=0
begin
	insert into System_Version(version_no,version_name)
	values ('1.0','标准版');
end
/**/GO
