﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="PurchaseOrders_Select.aspx.cs" Inherits="Component_AdvancedSearch_PurchaseOrders_Select" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/ListHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>选择采购订单</title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript">
        var io_id = '<%=Request["io_id"]%>';
        var order_rows_count = '<%=Request["order_rows_count"]%>';
        //搜索
        function search_grid() {
            var fg = document.getElementById("frame_grid");
            var begin_date = $("#begin_date").val();
            var end_date = $("#end_date").val();
            var keyword = $("#keyword").val();
            var order_number = $("#order_number").val();
            var i_code = $("#i_code").val();
            var i_name = $("#i_name").val();
            var standard = $("#standard").val();
            var free1 = $("#free1").val();
            var free2 = $("#free2").val();
            var vd_name = $("#vd_name").val();
            var dep_name = $("#dep_name").val();
            var pt_name = $("#pt_name").val();
            var status = $("#status").val();
            var url = "PurchaseOrders_Select_Grid.aspx?keyword=" + keyword
                    + "&io_id=" + io_id + "&order_number=" + order_number
                    + "&free1=" + free1 + "&free2=" + free2
                    + "&begin_date=" + begin_date + "&end_date=" + end_date
                    + "&i_code=" + i_code + "&i_name=" + i_name + "&standard=" + standard
                    + "&vd_name=" + vd_name + "&dep_name=" + dep_name + "&pt_name=" + pt_name + "&status=" + status;
            fg.src = url;
        }
        //选择
        function modify() {
            //表体首次新增时，强制使用多选，以带出表头信息
            if (order_rows_count == '0') {
                multi_select();
                return;
            }
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var id = cw.aw_GetSelectRows(cw._pos_id); //返回一维数组
            if (id.length == 0) {
                AlertNO('请选择记录!');
                return;
            }
            if (id.length > 1) {
                AlertNO('一次只可以选择一条!');
                return;
            }
            parent.asyncbox.opener('win_modify').SearchService_PurchaseOrders(id[0]);
            CloseDivWin(); //关闭窗口
        }
        //多选
        function multi_select() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var ids = cw.aw_GetSelectRows(cw._pos_id); //返回一维数组
            if (ids.length == 0) {
                AlertNO('请选择记录!');
                return;
            }
            parent.multi_select(ids);
            CloseDivWin(); //关闭窗口
        }
    </script>
</head>
<body onload="search_grid();">
    <!--工具栏-->
    <div style="height:30px;" class="list_menu_bar">
        <input type="text" class="keyword_box" id="keyword"/>
        <a plain="true" class="easyui-linkbutton" onclick="search_grid()">搜索</a>
        <a plain="true" class="easyui-linkbutton" onclick="$('#search_win').window('open')" iconcls="icon-search">高级搜索</a>
        <a plain="true" class="easyui-linkbutton" onclick="modify()">选择</a>
        <a plain="true" class="easyui-linkbutton" onclick="multi_select()" id="btn_multi_select">多选</a>
        <a plain="true" class="easyui-linkbutton" onclick="DesignModuleFormat('Dialog_PurchaseOrders_Details')">格式</a>
    </div>
    <!--Grid控件所在的iframe-->
    <%=xview["grid_frame"]%>
    <!--搜索窗口-->  
	<div id="search_win" class="easyui-dialog" title="搜索"
        data-options="modal:true,closed:true,closable: false,iconCls:'icon-search'"
        style="width:400px;height:400px;padding:10px;">
		<table style="margin:auto;">
            <tr>
                <td style="text-align:right">起始日期:</td>
                <td>
                    <input type="text" class="edit_text_box" id="begin_date" style='width:120px' onclick='ShowDateControl()'/></td>
            </tr>
            <tr>
                <td style="text-align:right">截止日期:</td>
                <td>
                    <input type="text" class="edit_text_box" id="end_date" style='width:120px' onclick='ShowDateControl()'/></td>
            </tr>
            <tr>
                <td style="text-align:right">入库状态:</td>
                <td>
                    <select id='status' class="edit_text_box">
                        <option value=""></option>
                        <option value="0" selected>未入完</option>
                        <option value="1">已入完</option>
                    </select></td>
            </tr>
            <tr>
                <td style="text-align:right">订单号:</td>
                <td><input type="text" class="edit_text_box" id="order_number"/></td>
            </tr>
            <tr>
                <td style="text-align:right">存货编码:</td>
                <td>
                    <input type="hidden" class="edit_text_box" id="i_id"/>
                    <input type="text" class="edit_text_box" id="i_code" style='width:98px'/></td>
            </tr>
            <tr>
                <td style="text-align:right">存货名称:</td>
                <td><input type="text" class="edit_text_box" id="i_name"/></td>
            </tr>
            <tr>
                <td style="text-align:right">规格型号:</td>
                <td><input type="text" class="edit_text_box" id="standard"/></td>
            </tr>
            <tr style="<%=cfg.DisplayFree1()%>">
                <td style="text-align:right"><%=cfg.Free1Title()%>:</td>
                <td>
                    <input type="text" class="edit_text_box" id="free1"/></td>
            </tr>
            <tr style="<%=cfg.DisplayFree2()%>">
                <td style="text-align:right"><%=cfg.Free2Title()%>:</td>
                <td>
                    <input type="text" class="edit_text_box" id="free2"/></td>
            </tr>
            <tr>
                <td style="text-align:right">供应商:</td>
                <td>
                    <input type="hidden" class="edit_text_box" id="vd_id"/>
                    <input type="text" class="edit_text_box" id="vd_name" style='width:98px'/></td>
            </tr>
            <tr>
                <td style="text-align:right">部门:</td>
                <td>
                    <input type="hidden" class="edit_text_box" id="dep_id"/>
                    <input type="text" class="edit_text_box" id="dep_name" style='width:98px'/></td>
            </tr>
            <tr>
                <td style="text-align:right">采购类型:</td>
                <td>
                    <input type="hidden" class="edit_text_box" id="pt_id"/>
                    <input type="text" class="edit_text_box" id="pt_name" style='width:98px'/></td>
            </tr>
		</table>
        <div style="margin-top:20px;text-align:center">
            <a href="javascript:search_grid()" class="easyui-linkbutton" onclick="javascript:$('#search_win').dialog('close')">搜索</a>
		    <a class="easyui-linkbutton" onClick="javascript:$('#search_win').dialog('close')">取消</a>
        </div>
	</div>
    <!--end of 搜索窗口--> 
    <script type="text/javascript">
        $(document).ready(function(){
            FastSearch_Vendor(); //查询供应商
            FastSearch_Department(); //查询部门
            FastSearch_PurchaseType(); //采购类型
            FastSearch_Inventory(); //查询存货
            $F("keyword").focus();
            $F("keyword").onkeypress = function (evt) {
                evt = evt ? evt : (window.event ? window.event : null);
                if (evt.keyCode == "13") {
                    search_grid();
                }
            }
            $F("btn_multi_select").title = "假如本单首次新增表体记录，【多选】可以把采购订单表头信息带到入库单表头上";
        });
    </script>
</body>
</html>
