﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;
public partial class Component_AdvancedSearch_PurchaseIns_Select_Grid : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    AWGridFun aw = new AWGridFun();
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!Page.IsPostBack)
        {
            CreateGrid();
        }
    }
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        //设置标题与样式
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        string sql_select_field = "";//SQL所需选择列
        string module = "Dialog_PurchaseIns_Select";//模块
        string fields_index = "";//列索引
        mfd.CreateTitlesAndStyles(module, ref aw, ref sql_select_field, ref fields_index);
        xview.Add("fields_index", fields_index);
        //把样式传递到页面
        xview.Add("aw_column_style",aw.GetStyles());
        int page = 1;//当前页
        if (Request.QueryString["page"] != null)
            page = Convert.ToInt32(Request.QueryString["page"]);
        int page_size = aw.GetDefaultPageSize();//每页显示条数
        if (Request.QueryString["page_size"] != null)
            page_size = Convert.ToInt32(Request.QueryString["page_size"]);
        
        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by io_id desc";
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";
        if (!Request["keyword"].Equals(""))
        {
            //要搜索关键字
            string keyword = Request["keyword"].ToString();
            //要搜索的字段
            string search_fields = "po_order_number,po_order_number,io_order_number,i_code,i_name,standard,free1,free2,"
                                + "munit,aunit,vd_name,dep_name,wh_name,new_user,verify_user,"
                                + "d_sdefine1,d_sdefine2,d_sdefine3,d_sdefine4,d_sdefine5,"
                                + "sdefine1,sdefine2,sdefine3,sdefine4,sdefine5";
            sql_end = FastSearh.MakeSearchSqlForWhere(keyword, search_fields);

        }
        if (!Request["begin_date"].Equals(""))
        {
            sql_end += " and new_date>='" + Request["begin_date"] + "'";
        }
        if (!Request["end_date"].Equals(""))
        {
            sql_end += " and new_date<='" + Request["end_date"] + "'";
        }
        if (!Request["po_order_number"].Equals(""))
        {
            sql_end += " and po_order_number like '%" + Request["po_order_number"] + "%'";
        }
        if (!Request["i_code"].Equals(""))
        {
            sql_end += " and i_code like '%" + Request["i_code"] + "%'";
        }
        if (!Request["i_name"].Equals(""))
        {
            sql_end += " and i_name like '%" + Request["i_name"] + "%'";
        }
        if (!Request["standard"].Equals(""))
        {
            sql_end += " and standard like '%" + Request["standard"] + "%'";
        }
        if (!Request["free1"].Equals(""))
        {
            sql_end += " and free1 like '%" + Request["free1"] + "%'";
        }
        if (!Request["free2"].Equals(""))
        {
            sql_end += " and free2 like '%" + Request["free2"] + "%'";
        }
        if (!Request["vd_name"].Equals(""))
        {
            sql_end += " and vd_name like '" + Request["vd_name"] + "'";
        }
        if (!Request["dep_name"].Equals(""))
        {
            sql_end += " and dep_name like '" + Request["dep_name"] + "'";
        }
        if (!Request["pt_name"].Equals(""))
        {
            sql_end += " and pt_name like '" + Request["pt_name"] + "'";
        }

        //已对完账
        if (Request["status"].Equals("1"))
        {
            sql_end += " and isnull(wait_dz_quantity,0)=0 ";
        }
        //未对完账
        if (Request["status"].Equals("0"))
        {
            sql_end += " and isnull(wait_dz_quantity,0)!=0";
        }
        //当前用户是否管理员
        bool is_admin = new AuthUI().CheckLoginUserIsAdmin();
        if (!is_admin)
        {
            //值为1代表启用部门权限控制
            string system_dep_auth = new ConfigReader().GetConfig("system_dep_auth");
            if (system_dep_auth.Equals("1"))
            {
                //只有客户专管业务员或业务主管才有权限看到
                sql_end += " and dep_id in (" + new AuthEx().GetSqlForMyDepartment() + ")";
            }
        }
        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = GetList(ht, sql_select_field);
        //得到总记录数为分页提供依据
        int rows_count = GetList_TotalNumbers(ht);
        //开启合计行功能
        aw.to_sum_row = true;
        //从模板读出哪些列需要合计
        aw.last_row_info = mfd.last_row_info;
        string aw_grid_info = aw.MakeGridObject(dt, rows_count, page_size, page);
        //把控件参数与数据源传递到页面
        xview.Add("aw_grid_info", aw_grid_info);
    }
    //列表查询用的sql
    string sql_list = @"
        	        select po.order_number as po_order_number,
                    t.order_number as io_order_number,
                    convert(char(10),t.new_date,23) as new_date,vd.vd_name,
	                pt.pt_name,t.dep_id,dep.dep_name,wh.wh_name,crc.crc_name,po.exchange_rate,t.remark,
	                t.sdefine1,t.sdefine2,t.sdefine3,t.sdefine4,t.sdefine5,
	                t.ndefine1,t.ndefine2,t.ndefine3,t.ndefine4,t.ndefine5,
                    t.new_user,t.verify_user,
	                d.*,i.i_code,i.i_name,i.standard,i.munit,i.aunit,
                    case when 
                    (d.quantity>0 and d.quantity-isnull(d.dz_quantity,0)>0)
                    or 
                    (d.quantity<0 and d.quantity-isnull(d.dz_quantity,0)<0) then 
                    d.quantity-isnull(d.dz_quantity,0) else 0 end as wait_dz_quantity
	                from Stock_InOuts d
	                left join Stock_InOut t on t.io_id=d.io_id
                    left join Purchase_PurchaseOrders pos on pos.pos_id=d.pos_id
                    left join Purchase_PurchaseOrder po on po.po_id=pos.po_id
	                left join Base_Vendor vd on t.vd_id=vd.vd_id
	                left join Base_PurchaseType pt on t.pt_id=pt.pt_id
	                left join Base_Department dep on t.dep_id=dep.dep_id
                    left join Base_Warehouse wh on t.wh_id=wh.wh_id
	                left join Base_Currency crc on po.crc_id=crc.crc_id
	                left join Base_Inventory i on d.i_id=i.i_id
                    where 1=1 and t.vd_id=@vd_id and isnull(t.verify_uid,0)<>0  ";
    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        int ca_id = Convert.ToInt32(Request.QueryString["ca_id"]);
        int? vd_id = new CheckAccountDAL().Get(ca_id).vd_id;
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(@sql_list)t where 1=1 ";
        if (vd_id != null)
        {
            sql_list = sql_list.Replace("@vd_id", vd_id.ToString());
        }
        else
        {
            sql_list = sql_list.Replace(" and t.vd_id=@vd_id", "");
        }
        if (!Request["ca_id"].Equals(""))
        {
            //不显示本对账单已选择过的采购入库记录
            sql_list += " and d.ios_id not in (select isnull(ios_id,0) from ARAP_CheckAccounts where ca_id=@ca_id) ";
        }
        sql_list = sql_list.Replace("@ca_id", ca_id.ToString());
        sql = sql.Replace("@sql_list", sql_list)
                 .Replace("@order_field", order_field)
                 .Replace("@sql_select_field", sql_select_field);
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        //Response.Write(sql);
        //Response.End();
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from (" + sql_list + ")t where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
}
