﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="GoodsCombo_Select.aspx.cs" Inherits="Component_AdvancedSearch_GoodsCombo_Select" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/ListHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>选择促销套餐</title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript">
        var io_id = '<%=Request["io_id"]%>';
        var order_rows_count = '<%=Request["order_rows_count"]%>';
        //搜索
        function search_grid() {
            var fg = document.getElementById("frame_grid");
            var begin_date = $("#begin_date").val();
            var end_date = $("#end_date").val();
            var keyword = $("#keyword").val();
            var url = "GoodsCombo_Select_Grid.aspx?keyword=" + keyword
                    + "&begin_date=" + begin_date + "&end_date=" + end_date;
            fg.src = url;
        }
        //选择
        function modify() {
            //表体首次新增时，强制使用多选，以带出表头信息
            if (order_rows_count == '0') {
                multi_select();
                return;
            }
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var id = cw.aw_GetSelectRows(cw._gc_id); //返回一维数组
            if (id.length == 0) {
                AlertNO('请选择记录!');
                return;
            }
            if (id.length > 1) {
                AlertNO('一次只可以选择一条记录!');
                return;
            }
            var qty = prompt("请输入要套餐数量", "1");
            if (qty == "" || isNaN(qty)) {
                alert("套餐数量不允许为空或非数值!");
                return;
            }
            parent.SearchService_GoodsCombo(id[0], qty);
            CloseDivWin(); //关闭窗口
        }
    </script>
</head>
<body onload="search_grid();">
    <!--工具栏-->
    <div style="height:30px;" class="list_menu_bar">
        <input type="text" class="keyword_box" id="keyword"/>
        <a plain="true" class="easyui-linkbutton" onclick="search_grid()">搜索</a>
        <a plain="true" class="easyui-linkbutton" onclick="$('#search_win').window('open')" iconcls="icon-search">高级搜索</a>
        <a plain="true" class="easyui-linkbutton" onclick="modify()">选择</a>
        <a plain="true" class="easyui-linkbutton" onclick="DesignModuleFormat('Dialog_GoodsCombo_Details')">格式</a>
    </div>
    <!--Grid控件所在的iframe-->
    <%=xview["grid_frame"]%>
    <!--搜索窗口-->  
	<div id="search_win" class="easyui-dialog" title="搜索"
        data-options="modal:true,closed:true,closable: false,iconCls:'icon-search'"
        style="width:400px;height:400px;padding:10px;">
		<table style="margin:auto;">
            <tr>
                <td style="text-align:right">起始日期:</td>
                <td>
                    <input type="text" class="edit_text_box" id="begin_date" style='width:120px' onclick='ShowDateControl()'/></td>
            </tr>
            <tr>
                <td style="text-align:right">截止日期:</td>
                <td>
                    <input type="text" class="edit_text_box" id="end_date" style='width:120px' onclick='ShowDateControl()'/></td>
            </tr>
		</table>
        <div style="margin-top:20px;text-align:center">
            <a href="javascript:search_grid()" class="easyui-linkbutton" onclick="javascript:$('#search_win').dialog('close')">搜索</a>
		    <a class="easyui-linkbutton" onclick="javascript:$('#search_win').dialog('close')">取消</a>
        </div>
	</div>
    <!--end of 搜索窗口--> 
    <script type="text/javascript">
        $(document).ready(function(){
            $F("keyword").focus();
            $F("keyword").onkeypress = function (evt) {
                evt = evt ? evt : (window.event ? window.event : null);
                if (evt.keyCode == "13") {
                    search_grid();
                }
            }
        });
    </script>
</body>
</html>
