﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;
using SysCore.Model;
using SysCore.DAL;

public partial class Component_AdvancedSearch_Department_Tree : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!Page.IsPostBack)
        {
            CreateTree();
        }
    }
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateTree()
    {
        string where = "where is_stop=0";
        string keyword = Request.QueryString["keyword"];
        if (!keyword.Equals(""))
        {
            //只搜索末级
            where += " and (dep_code like '%" + keyword + "%' or dep_name like '%" + keyword + "%' or dep_id in (select parent_id from Base_Department)) "; 
        }
        DataTable tb = new DepartmentDAL().GetListAll(where);
        DTree dt = new DTree("dt");
        dt.AddParentNode("0", "-1", "选择部门");
        foreach (DataRow dr in tb.Rows)
        {
            string dep_id = dr["dep_id"].ToString();
            string parent_id = dr["parent_id"].ToString();
            string dep_code = dr["dep_code"].ToString(); 
            string dep_name = dr["dep_name"].ToString();
            dt.AddChildNode(dep_id, parent_id, dep_code + " " + dep_name, "javascript:SelectCategory(\\'" + dep_id + "\\')", "", "", "../../Scripts/dtree/images/folder.gif");
        }
        xview.Add("dtree", dt.GetTree());
    }
}
