﻿<%@ WebService Language="C#" Class="DefineItem_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class DefineItem_Service : System.Web.Services.WebService
{
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        DefineItemDAL dal = new DefineItemDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public DefineItem Get(string di_id)
    {
        DefineItemDAL dal = new DefineItemDAL();
        return dal.Get(Convert.ToInt32(di_id));
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string di_code, string di_id, string di_value)
    {
        di_value = di_value.Trim();
        if (di_value.Equals(""))
        {
            return "值不可为空！";
        }
        if (di_code.Equals(""))
        {
            return "所属字段不可为空！";
        }
        try
        {
            DefineItemDAL dal = new DefineItemDAL();

            DefineItem m = new DefineItem();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(di_id));
            }
            m.di_code = di_code;
            m.di_value = di_value;
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(di_value))
                {
                    return "值:" + di_value + "已存在！";
                }
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}