﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="DefineItem_Select.aspx.cs" Inherits="Component_AdvancedSearch_DefineItem_Select" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/ListHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>选择</title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript">
        var di_code = '<%=Request["di_code"]%>';
        //搜索
        function search_grid() {
            
            var fg = document.getElementById("frame_grid");
            var keyword = $("#keyword").val();
            var url = "DefineItem_Select_Grid.aspx?di_code=" + di_code + "&keyword=" + escape(keyword);
            fg.src = url;
        }
        //新增
        function add() {
            asyncbox.open({
                id: 'win_add',
                url: 'DefineItem_Edit.aspx?action=Add&di_code=' + di_code,
                modal:true,
                title:'新增'
	        });
        }
        var element_id = '<%=Request["element_id"]%>';
        //选择
        function modify() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var id = cw.aw_GetSelectRows(cw._di_value); //返i回一维数组
            if (id.length == 0) {
                AlertNO('请选择记录!');
                return;
            }
            if (id.length > 1) {
                AlertNO('一次只可以选择一条!');
                return;
            }
            /*window.returnValue = id[0];
            self.close();*/
            if (id != null) {
                parent.$("#" + element_id).val(id);
            } else {
                parent.$("#" + element_id).val("");
            }
            CloseDivWin(); //关闭窗口
        }
        //修改
        function edit() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._di_id); //返回一维数组

            if (id.length == 0) {
                AlertNO('请选择要查看的记录!');
                return;
            }
            if (id.length > 1) {
                AlertNO('一次只可以查看一条记录!');
                return;
            }
            asyncbox.open({
                id: 'win_modify',
                url: 'DefineItem_Edit.aspx?action=Update&id=' + id + '&di_code=' + di_code,
                modal: true,
                title: '修改'
            });
            
        }
        //删除
        function del() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._di_id);//返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要删除的记录!');
                return;
            }
            asyncbox.confirm('确定要删除吗', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: "DefineItem_Service.asmx/Delete",
                        data: "{ids:'" + id + "'}",
                        dataType: 'json',
                        success: function (result) {
                            var r = result.d;
                            if (r == "success") {
                                AlertOK('删除成功!');
                                search_grid();
                            } else {
                                AlertNO(r);
                            }
                            HideLoadingMask(); //关闭遮罩
                        }
                    });
                }
            });
        }
        
    </script>
</head>
<body onload="search_grid();">
    <!--工具栏-->
    <div style="height:30px;" class="list_menu_bar">
        <input type="text" class="edit_text_box" id="keyword" value="<%=keyword%>"/>
        <a href="javascript:search_grid()" plain="true" class="easyui-linkbutton" iconcls="icon-search">搜索</a>
        <a plain="true" class="easyui-linkbutton" onclick="add()">新增</a>
        <a plain="true" class="easyui-linkbutton" onclick="edit()">修改</a>
        <a plain="true" class="easyui-linkbutton" onclick="del()">删除</a>
        <a plain="true" class="easyui-linkbutton" onclick="DesignModuleFormat('Dialog_DefineItem_List')" style='<%=auth.FormatView()%>'>格式</a>
    </div>
    <!--Grid控件所在的iframe-->
    <%=xview["grid_frame"]%>
    <script type="text/javascript">
        //搜索框回车事件
        $('#keyword').keyup(function (e) {
            if (e.keyCode == 13) {
                search_grid();
            }
        });
        $('#keyword').focus();
    </script>
</body>
</html>
