﻿<%@ WebService Language="C#" Class="Warehouse_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Warehouse_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        WarehouseDAL dal = new WarehouseDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "该仓库可能已被使用，不允许删除！"; 
                //return e.Message;
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public Warehouse Get(string wh_id)
    {
        WarehouseDAL dal = new WarehouseDAL();
        return dal.Get(Convert.ToInt32(wh_id));
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string wh_id, string wh_code, string wh_name, 
        string is_control_stock, string is_stop)
    {
        wh_code = wh_code.Trim();
        if (wh_code.Equals(""))
        {
            return "仓库编码不可为空！";
        }
        wh_name = wh_name.Trim();
        if (wh_name.Equals(""))
        {
            return "仓库名称不可为空！";
        }

        try
        {
            WarehouseDAL dal = new WarehouseDAL();

            Warehouse m = new Warehouse();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(wh_id));
            }
            m.wh_code = wh_code;
            m.wh_name = wh_name;
            m.is_control_stock = Convert.ToInt32(is_control_stock);
            m.is_stop = Convert.ToInt32(is_stop);
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(wh_code))
                {
                    return "仓库编码" + wh_code + "已存在！";
                }
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}