﻿<%@ WebService Language="C#" Class="Vendor_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Vendor_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        VendorDAL dal = new VendorDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "该供应商可能已被使用，不允许删除！";
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public Vendor Get(string vd_id)
    {
        VendorDAL dal = new VendorDAL();
        return dal.Get(Convert.ToInt32(vd_id));
    }
    /// <summary>
    /// 保存
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string vd_id, string vd_code, string vd_name, string vc_id,
        string is_stop, string ele_id, string vd_full_name, string arrive_address,
        string contact,string legal_person,string phone,string cellphone,string fax,
        string bank_of_deposit, string banking_account, string email, string qq, string address,
        string sdefine1,string sdefine2,string sdefine3,string sdefine4,string sdefine5,
        string ndefine1,string ndefine2,string ndefine3,string ndefine4,string ndefine5)
    {
        try
        {
            vd_code = vd_code.Trim();
            if (vd_code.Equals(""))
            {
                return "供应商编码不可为空！";
            }
            vd_name = vd_name.Trim();
            if (vd_name.Equals(""))
            {
                return "供应商名称不可为空！";
            }
            if (vc_id.Equals("") || vc_id.Equals("0"))
            {
                return "请选择供应商分类！";
            }       
            VendorDAL dal = new VendorDAL();
            Vendor m = new Vendor();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(vd_id));
            }
            m.vd_code = vd_code;
            m.vd_name = vd_name;
            m.vc_id = Convert.ToInt32(vc_id);
            m.is_stop = Convert.ToInt32(is_stop);
            m.ele_id = XTools.ObjectNullToInt(ele_id);
            m.vd_full_name = vd_full_name;
            m.arrive_address = arrive_address;
            m.contact = contact;
            m.legal_person = legal_person;
            m.phone = phone;
            m.fax = fax;
            m.cellphone = cellphone;
            m.bank_of_deposit = bank_of_deposit;
            m.banking_account = banking_account;
            m.email = email;
            m.qq = qq;
            m.address = address;
            m.sdefine1 = sdefine1;
            m.sdefine2 = sdefine2;
            m.sdefine3 = sdefine3;
            m.sdefine4 = sdefine4;
            m.sdefine5 = sdefine5;
            m.ndefine1 = XTools.ObjectNullToDecimal(ndefine1);
            m.ndefine2 = XTools.ObjectNullToDecimal(ndefine2);
            m.ndefine3 = XTools.ObjectNullToDecimal(ndefine3);
            m.ndefine4 = XTools.ObjectNullToDecimal(ndefine4);
            m.ndefine5 = XTools.ObjectNullToDecimal(ndefine5);
            
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(vd_code))
                {
                    return "供应商编码" + vd_code + "已存在！";
                }
                if (dal.CheckNameExist(vd_name))
                {
                    return "供应商名称" + vd_name + "已存在！";
                }
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}