﻿<%@ WebService Language="C#" Class="VendorClass_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class VendorClass_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        VendorClassDAL dal = new VendorClassDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                if (dal.CheckHasChild(Convert.ToInt32(id)))
                {
                    return "存在子类，不允许删除！";
                }
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "该分类可能已被使用，不允许删除！";
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public VendorClass Get(string vc_id)
    {
        VendorClassDAL dal = new VendorClassDAL();
        return dal.Get(Convert.ToInt32(vc_id));
    }
    /// <summary>
    /// 保存
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string vc_id, string vc_code, string vc_name,string parent_id)
    {
        vc_code = vc_code.Trim();
        if (vc_code.Equals(""))
        {
            return "分类编码不可为空！";
        }
        vc_name = vc_name.Trim();
        if (vc_name.Equals(""))
        {
            return "分类名称不可为空！";
        }
        try
        {
            VendorClassDAL dal = new VendorClassDAL();
            if (!parent_id.Equals("") && !parent_id.Equals("0"))
            {

                VendorClass parent = dal.Get(Convert.ToInt32(parent_id));

                if (!dal.CheckLikeParent(vc_code, parent.vc_code))
                {
                    return "分类编码与父级分类规则不一致!";
                }
            }
            VendorClass m = new VendorClass();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(vc_id));
            }
            m.vc_id = Convert.ToInt32(vc_id);
            
            m.vc_code = vc_code;
            m.vc_name = vc_name;
            if (!parent_id.Equals(""))
            {
                m.parent_id = Convert.ToInt32(parent_id);
            }
            else
            {
                m.parent_id = 0;
            }
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(vc_code))
                {
                    return "分类编码" + vc_code + "已存在！";
                }
                dal.Add(m);
            }
            //更新分类级次
            dal.FetchNodeAndUpdateLayer(0, 1);
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}