﻿<%@ WebService Language="C#" Class="ShipWay_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class ShipWay_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        ShipWayDAL dal = new ShipWayDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "删除失败！该发运方式可能已被使用。";
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public ShipWay Get(string sw_id)
    {
        ShipWayDAL dal = new ShipWayDAL();
        return dal.Get(Convert.ToInt32(sw_id));
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string sw_id, string sw_code, string sw_name, string is_default)
    {
        sw_code = sw_code.Trim();
        if (sw_code.Equals(""))
        {
            return "发运方式编码不可为空！";
        }
        sw_name = sw_name.Trim();
        if (sw_name.Equals(""))
        {
            return "发运方式名称不可为空！";
        }

        try
        {
            ShipWayDAL dal = new ShipWayDAL();

            ShipWay m = new ShipWay();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(sw_id));
            }
            m.sw_code = sw_code;
            m.sw_name = sw_name;
            m.is_default = Convert.ToInt32(is_default);
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(sw_code))
                {
                    return "发运方式编码" + sw_code + "已存在！";
                }
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}