﻿<%@ WebService Language="C#" Class="SettleStyle_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class SettleStyle_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        SettleStyleDAL dal = new SettleStyleDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "删除失败！该结算方式可能已被使用。";
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public SettleStyle Get(string ss_id)
    {
        SettleStyleDAL dal = new SettleStyleDAL();
        return dal.Get(Convert.ToInt32(ss_id));
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string ss_id, string ss_code, string ss_name, string is_default)
    {
        ss_code = ss_code.Trim();
        if (ss_code.Equals(""))
        {
            return "结算方式编码不可为空！";
        }
        ss_name = ss_name.Trim();
        if (ss_name.Equals(""))
        {
            return "结算方式名称不可为空！";
        }

        try
        {
            SettleStyleDAL dal = new SettleStyleDAL();

            SettleStyle m = new SettleStyle();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(ss_id));
            }
            m.ss_code = ss_code;
            m.ss_name = ss_name;
            m.is_default = Convert.ToInt32(is_default);
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(ss_code))
                {
                    return "结算方式编码" + ss_code + "已存在！";
                }
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}