﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="SettleStyle_List.aspx.cs" Inherits="Base_SettleStyle_SettleStyle_List" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/ListHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript">
        //搜索
        function search_grid() {
            
            var fg = document.getElementById("frame_grid");
            var ss_code = $("#ss_code").val();
            var ss_name = $("#ss_name").val();
            var url = "SettleStyle_List_Grid.aspx?ss_code=" + ss_code + "&ss_name=" + ss_name;
            fg.src = url;
        }
        //新增
        function add() {
            asyncbox.open({
                id: 'win_modify',
	            url: 'SettleStyle_Edit.aspx?action=Add',
                modal:true,
                title:'新增'
	        });
        }
        //修改
        function modify() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._ss_id); //返回一维数组

            if (id.length == 0) {
                AlertNO('请选择要查看的记录!');
                return;
            }
            if (id.length > 1) {
                AlertNO('一次只可以查看一条记录!');
                return;
            }
            asyncbox.open({
                id: 'win_modify',
                url: 'SettleStyle_Edit.aspx?action=Update&id=' + id,
                modal: true,
                title: '修改'
            });
            
        }
        //删除
        function del() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._ss_id);//返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要删除的记录!');
                return;
            }
            asyncbox.confirm('确定要删除吗', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: "SettleStyle_Service.asmx/Delete",
                        data: "{ids:'" + id + "'}",
                        dataType: 'json',
                        success: function (result) {
                            var r = result.d;
                            if (r == "success") {
                                AlertOK('删除成功!');
                                search_grid();
                            } else {
                                AlertNO(r);
                            }
                            HideLoadingMask(); //关闭遮罩
                        }
                    });
                }
            });
        }
        
    </script>
</head>
<body onLoad="search_grid();">
    <!--工具栏-->
    <div style="height:30px;" class="liss_menu_bar">
        <a plain="true" class="easyui-linkbutton" onClick="$('#search_win').window('open')" iconcls="icon-search">搜索</a>
        <a plain="true" class="easyui-linkbutton" onClick="add()" style='<%=auth.AuthView("Base_SettleStyle_Edit")%>'>新增</a>
        <a plain="true" class="easyui-linkbutton" onClick="modify()">查看</a>
        <a plain="true" class="easyui-linkbutton" onClick="del()" style='<%=auth.AuthView("Base_SettleStyle_Delete")%>'>删除</a>
        <a plain="true" class="easyui-linkbutton" onClick="DesignModuleFormat('Base_SettleStyle_List')" style='<%=auth.FormatView()%>'>格式</a>
    </div>
    <!--Grid控件所在的iframe-->
    <%=xview["grid_frame"]%>
    <!--搜索窗口-->  
	<div id="search_win" class="easyui-dialog" title="搜索"
        data-options="modal:true,closed:true,iconCls:'icon-search'"
        style="width:400px;height:300px;padding:10px;">
		<table style="margin:auto;">
            <tr>
                <td style="text-align:right">销售类型编码:</td>
                <td><input type="text" class="edit_text_box" id="ss_code"/></td>
            </tr>
            <tr>
                <td style="text-align:right">销售类型名称:</td>
                <td><input type="text" class="edit_text_box" id="ss_name"/></td>
            </tr>
		</table>
        <div style="margin-top:20px;text-align:center">
            <a href="javascript:search_grid()" class="easyui-linkbutton" onClick="javascript:$('#search_win').dialog('close')">搜索</a>
		    <a class="easyui-linkbutton" onClick="javascript:$('#search_win').dialog('close')">取消</a>
        </div>
	</div>
    <!--end of 搜索窗口--> 
</body>
</html>
