﻿<%@ WebService Language="C#" Class="SaleType_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class SaleType_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        SaleTypeDAL dal = new SaleTypeDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "删除失败！该销售类型可能已被使用。";
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public SaleType Get(string st_id)
    {
        SaleTypeDAL dal = new SaleTypeDAL();
        return dal.Get(Convert.ToInt32(st_id));
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string st_id, string st_code, string st_name, string is_default)
    {
        st_code = st_code.Trim();
        if (st_code.Equals(""))
        {
            return "销售类型编码不可为空！";
        }
        st_name = st_name.Trim();
        if (st_name.Equals(""))
        {
            return "销售类型名称不可为空！";
        }

        try
        {
            SaleTypeDAL dal = new SaleTypeDAL();

            SaleType m = new SaleType();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(st_id));
            }
            m.st_code = st_code;
            m.st_name = st_name;
            m.is_default = Convert.ToInt32(is_default);
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(st_code))
                {
                    return "销售类型编码" + st_code + "已存在！";
                }
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}