﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;
public partial class Base_RunningNumber_Edit_Grid : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    AWGridFun aw = new AWGridFun();
    public string module_code;
    protected void Page_Load(object sender, EventArgs e)
    {
        new LoginState().CheckLogin();
        if(!Page.IsPostBack)
        {
            module_code = Request.QueryString["module_code"];

            CreateGrid();
        }
    }

    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        //设置标题与样式
        aw.SetColumn("行号", "width:50px;text-align:right;");
        aw.SetColumn("ID", "width:50px;display:none");
        aw.SetColumn("模块", "width:150px;display:none");
        aw.SetColumn("流水依据", "width:150px;text-align:right;");
        aw.SetColumn("当前流水号", "width:100px;text-align:right;color:blue;");
        //把样式传递到页面
        xview.Add("aw_column_style", aw.GetStyles());
        int page = 1;//当前页
        if (Request.QueryString["page"] != null)
            page = Convert.ToInt32(Request.QueryString["page"]);
        int page_size = 500;// aw.GetDefaultPageSize();//每页显示条数
        if (Request.QueryString["page_size"] != null)
            page_size = Convert.ToInt32(Request.QueryString["page_size"]);

        RunningNumberDAL dal = new RunningNumberDAL();
        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by rn_id desc";
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";
        sql_end = " and module_code='" + module_code + "' ";
        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = dal.GetList(ht);
        //得到总记录数为分页提供依据
        int rows_count = dal.GetList_TotalNumbers(ht);
        string aw_grid_info = aw.MakeGridObject(dt, rows_count, page_size, page);
        //把控件参数与数据源传递到页面
        xview.Add("aw_grid_info", aw_grid_info);
    }
}
