﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;
using SysCore.Model;
using SysCore.DAL;

public partial class Base_RunningNumberRule_RunningNumberRule_Tree : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!Page.IsPostBack)
        {
            CreateTree();
        }
    }
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateTree()
    {
        string where = " and (isnull(url,'')='' or module_code in (select module_code from Base_RunningNumberRule))";
        DataTable tb = new ModuleDAL().GetList(where);
        DTree dt = new DTree("dt");
        dt.AddParentNode("0", "-1", "系统模块");
        foreach (DataRow dr in tb.Rows)
        {
            string module_code = dr["module_code"].ToString();
            string category = dr["category"].ToString();
            string module_name = dr["module_name"].ToString();
            string url = dr["url"].ToString();
            if (category.Equals(""))
            {
                category = "0";
            }
            if (url.Equals(""))
            {
                dt.AddChildNode(module_code, category, module_name, "", "", "", "../../Scripts/dtree/images/folder.gif");
            }
            else
            {
                dt.AddChildNode(module_code, category, module_name, "javascript:SelectCategory(\\'"+module_code+"\\')", "", "", "../../Scripts/dtree/images/folder.gif");
            }
        }

        xview.Add("dtree", dt.GetTree());
    }
}
