﻿<%@ WebService Language="C#" Class="Config_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Config_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string module_code,string length, string rule1, string manual1, string date1,
                        string rule2, string manual2, string date2,
                        string rule3, string manual3, string date3)
    {
        length = length.Trim();

        if (length.Trim().Equals(""))
        {
            return "流水号长度不可为空！";
        }
        if (!XTools.IsPositiveInt(length))
        {
            return "流水号长度必须为正整数!";
        }
        
        try
        {
            RunningNumberRuleDAL dal = new RunningNumberRuleDAL();
            RunningNumberRule m = dal.Get(module_code);
            
            m.length = Convert.ToInt32(length);
            m.rule1 = rule1;
            m.rule2 = rule2;
            m.rule3 = rule3;

            m.rule1 = rule1;
            m.rule2 = rule2;
            m.rule3 = rule3;

            m.rule1 = rule1;
            m.rule2 = rule2;
            m.rule3 = rule3;

            m.rule1_value = "[" + rule1 + "]";
            m.rule2_value = "[" + rule2 + "]";
            m.rule3_value = "[" + rule3 + "]";

            if (m.rule1.Equals("manual"))
            {
                if (manual1.Equals(""))
                    return "前缀1为手工输入时，请在右边文本框手工输入值!";
                m.rule1_value = manual1;
            }
            if (m.rule2.Equals("manual"))
            {
                if (manual2.Equals(""))
                    return "前缀2为手工输入时，请在右边文本框手工输入值!";
                m.rule2_value = manual2;
            }
            if (m.rule3.Equals("manual"))
            {
                if (manual3.Equals(""))
                    return "前缀3为手工输入时，请在右边文本框手工输入值!";
                m.rule3_value = manual3;
            }

            if (m.rule1.Equals("date"))
                m.rule1_value = date1;
            if (m.rule2.Equals("date"))
                m.rule2_value = date2;
            if (m.rule3.Equals("date"))
                m.rule3_value = date3;

            if (m.rule1.Equals(""))
                m.rule1_value = "";
            if (m.rule2.Equals(""))
                m.rule2_value = "";
            if (m.rule3.Equals(""))
                m.rule3_value = "";
            
            dal.Update(m);
           
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}