﻿<%@ WebService Language="C#" Class="PurchaseType_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class PurchaseType_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        PurchaseTypeDAL dal = new PurchaseTypeDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public PurchaseType Get(string pt_id)
    {
        PurchaseTypeDAL dal = new PurchaseTypeDAL();
        return dal.Get(Convert.ToInt32(pt_id));
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string pt_id, string pt_code, string pt_name, string is_default)
    {
        pt_code = pt_code.Trim();
        if (pt_code.Equals(""))
        {
            return "采购类型编码不可为空！";
        }
        pt_name = pt_name.Trim();
        if (pt_name.Equals(""))
        {
            return "采购类型名称不可为空！";
        }

        try
        {
            PurchaseTypeDAL dal = new PurchaseTypeDAL();

            PurchaseType m = new PurchaseType();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(pt_id));
            }
            m.pt_code = pt_code;
            m.pt_name = pt_name;
            m.is_default = Convert.ToInt32(is_default);
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(pt_code))
                {
                    return "采购类型编码" + pt_code + "已存在！";
                }
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}