﻿<%@ WebService Language="C#" Class="Inventory_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Transactions;
using SysCore;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Inventory_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        InventoryDAL dal = new InventoryDAL();
        InventoryPhotoDAL p_dal = new InventoryPhotoDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                                //启用事务
                using (TransactionScope scope = new TransactionScope())
                {
                    int i_id = Convert.ToInt32(id);
                    //删图片
                    p_dal.DeleteByInventory(i_id);
                    //删存货
                    dal.Delete(i_id);
                    //提交事务
                    scope.Complete();
                }
            }
            catch
            {
                return "该档案已被使用，不允许删除！";// err.Message;
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string GetIdByCode(string i_code)
    {
        InventoryDAL dal = new InventoryDAL();
        return dal.GetIdByCode(i_code).ToString();
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public Inventory Get(string i_id)
    {
        InventoryDAL dal = new InventoryDAL();
        return dal.Get(Convert.ToInt32(i_id));
    }
    /// <summary>
    /// 保存
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string i_id, string i_code, string i_name, string ic_id,
        string standard, string munit, string aunit, string convert_rate, string vd_id, string wh_id,
        string valuation, string on_free1, string on_free2, string on_batch,
        string is_sale, string is_purchase, string is_self, string is_outsource, string is_service,
        string safety_stock, string min_stock, string max_stock, string purchase_batch,string stop_date,
        string new_tax_unit_price, string new_nat_unit_price,
        string sdefine1,string sdefine2,string sdefine3,string sdefine4,string sdefine5,
        string ndefine1,string ndefine2,string ndefine3,string ndefine4,string ndefine5)
    {
        i_code = i_code.Trim();
        if (i_code.Equals(""))
        {
            return "存货编码不可为空！";
        }
        
        i_name = i_name.Trim();
        if (i_name.Equals(""))
        {
            return "存货名称不可为空！";
        }
        if (ic_id.Trim().Equals(""))
        {
            return "存货分类不可为空！";
        }
        if (munit.Trim().Equals(""))
        {
            return "主计量单位不可为空！";
        }
        if (ndefine1.Equals("")) ndefine1 = null;
        if (ndefine2.Equals("")) ndefine2 = null;
        if (ndefine3.Equals("")) ndefine3 = null;
        if (ndefine4.Equals("")) ndefine4 = null;
        if (ndefine5.Equals("")) ndefine5 = null;
        try
        {
            InventoryDAL dal = new InventoryDAL();
            InventoryClassDAL ic_dal = new InventoryClassDAL();
            Inventory m = new Inventory();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(i_id));
            }
            m.i_code = i_code;
            m.i_name = i_name;
            if (!ic_id.Equals(""))
            {
                m.ic_id = Convert.ToInt32(ic_id);
            }
            else
            {
                m.ic_id = 0;
            }
            try
            {
                m.standard = XTools.ObjectNullToString(standard);
                m.munit = XTools.ObjectNullToString(munit);
                m.aunit = XTools.ObjectNullToString(aunit);
                m.convert_rate = XTools.ObjectNullToDecimal(convert_rate);
                m.vd_id = XTools.ObjectNullToInt(vd_id);
                m.wh_id = XTools.ObjectNullToInt(wh_id);
                m.valuation = XTools.ObjectNullToString(valuation);
                m.on_free1 = Convert.ToInt32(on_free1);
                m.on_free2 = Convert.ToInt32(on_free2);
                m.on_batch = Convert.ToInt32(on_batch);
                m.is_sale = Convert.ToInt32(is_sale);
                m.is_purchase = Convert.ToInt32(is_purchase);
                m.is_self = Convert.ToInt32(is_self);
                m.is_outsource = Convert.ToInt32(is_outsource);
                m.is_service = Convert.ToInt32(is_service);
                m.safety_stock = XTools.ObjectNullToDecimal(safety_stock);
                m.min_stock = XTools.ObjectNullToDecimal(min_stock);
                m.max_stock = XTools.ObjectNullToDecimal(max_stock);
                m.purchase_batch = XTools.ObjectNullToDecimal(purchase_batch);
                m.new_tax_unit_price = XTools.ObjectNullToDecimal(new_tax_unit_price);
                m.new_nat_unit_price = XTools.ObjectNullToDecimal(new_nat_unit_price);
                m.stop_date = XTools.ObjectNullToDateTime(stop_date);
                m.sdefine1 = XTools.ObjectNullToString(sdefine1);
                m.sdefine2 = XTools.ObjectNullToString(sdefine2);
                m.sdefine3 = XTools.ObjectNullToString(sdefine3);
                m.sdefine4 = XTools.ObjectNullToString(sdefine4);
                m.sdefine5 = XTools.ObjectNullToString(sdefine5);
                m.ndefine1 = XTools.ObjectNullToDecimal(ndefine1);
                m.ndefine2 = XTools.ObjectNullToDecimal(ndefine2);
                m.ndefine3 = XTools.ObjectNullToDecimal(ndefine3);
                m.ndefine4 = XTools.ObjectNullToDecimal(ndefine4);
                m.ndefine5 = XTools.ObjectNullToDecimal(ndefine5);

                if (ic_dal.CheckHasChild(m.ic_id))
                {
                    return "非末级分类不允许增加存货！";
                }
                
            }
            catch (Exception err)
            {
                return err.Message;
            }
            LoginInfo li = new LoginInfo();
            if (action.Equals("Update"))
            {
                m.updater_id = li.uid;
                m.update_date = DateTime.Now;
                dal.Update(m);
            }
            else
            {
                
                if (dal.CheckExist(i_code))
                {
                    return "存货编码" + i_code + "已存在！";
                }
                m.updater_id = li.uid;
                m.add_date = DateTime.Now;
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}