﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Drawing;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
using System.Web.UI.HtmlControls;
using System.IO;
using SysCore;
public partial class Base_Inventory_Inventory_Photo_Upload : System.Web.UI.Page
{
    string id;
    protected void Page_Load(object sender, EventArgs e)
    {
        id = Request.QueryString["id"];
        if (!Page.IsPostBack)
        {
            InventoryPhotoDAL dal = new InventoryPhotoDAL();
            if (dal.CheckExist(Convert.ToInt32(id)))
            {
                InventoryPhoto ip = dal.GetByInventory(Convert.ToInt32(id));
                photo_view.ImageUrl = ip.pic_url;
            }
            else
            {
                photo_view.ImageUrl = "../../Images/Common/no_photo.jpg";
            }
        }        
    }
    protected void btn_upload_Click(object sender, EventArgs e)
    {
        string [] arr = file_upload.FileName.Split('.');
        string ext = arr[arr.Length-1].ToLower();
        if (!(ext.Equals("jpg") || ext.Equals("jpeg") || ext.Equals("gif") || ext.Equals("png") || ext.Equals("bmp")))
        {
            Response.Write("请上传图片格式!");
            Response.Write("<br/><a href='javascript:window.history.go(-1);'>返回</a>");
            Response.End();
        }
        string db_id = new LoginInfo().db_id.ToString();
        string filename = XTools.GetRandom(6);
        string save_path_base = "../../Upload/" + db_id + "/InventoryPhoto";
        if(!Directory.Exists(Server.MapPath(save_path_base)))
        {
            Directory.CreateDirectory(Server.MapPath(save_path_base));
        }
        string save_path = save_path_base + "/" + filename;
        string real_save_path = Server.MapPath(save_path + "." + ext);
        string small_save_path = save_path + "_small";
        string small_real_save_path = Server.MapPath(small_save_path + "." + ext);
        file_upload.SaveAs(real_save_path);
        photo_view.ImageUrl = save_path + "." + ext;
        InventoryPhotoDAL dal = new InventoryPhotoDAL();
        InventoryPhoto ip = new InventoryPhoto();
        if (dal.CheckExist(Convert.ToInt32(id)))
        {
            ip = dal.GetByInventory(Convert.ToInt32(id));
        }
        SendSmallImage(real_save_path, small_real_save_path, 150, 150);
        ip.i_id = Convert.ToInt32(id);
        if (dal.CheckExist(Convert.ToInt32(id)))
        {
            File.Delete(Server.MapPath(ip.pic_url));
            File.Delete(Server.MapPath(ip.small_pic_url));
            ip.pic_url = save_path + "." + ext;
            ip.small_pic_url = small_save_path + "." + ext;
            dal.UpdateByInventory(ip);
        }
        else
        {
            ip.pic_url = save_path + "." + ext;
            ip.small_pic_url = small_save_path + "." + ext;
            dal.Add(ip);
        }
    }

    private static Size NewSize(int maxWidth, int maxHeight, int width, int height)
    {
        double w = 0.0;
        double h = 0.0;
        double sw = Convert.ToDouble(width);
        double sh = Convert.ToDouble(height);
        double mw = Convert.ToDouble(maxWidth);
        double mh = Convert.ToDouble(maxHeight);

        if (sw < mw && sh < mh)
        {
            w = sw;
            h = sh;
        }
        else if ((sw / sh) > (mw / mh))
        {
            w = maxWidth;
            h = (w * sh) / sw;
        }
        else
        {
            h = maxHeight;
            w = (h * sw) / sh;
        }

        return new Size(Convert.ToInt32(w), Convert.ToInt32(h));
    }

    public static void SendSmallImage(string fileName, string newFile, int maxHeight, int maxWidth)
    {
        System.Drawing.Image img = System.Drawing.Image.FromFile(fileName);
        System.Drawing.Imaging.ImageFormat thisFormat = img.RawFormat;

        Size newSize = NewSize(maxWidth, maxHeight, img.Width, img.Height);
        Bitmap outBmp = new Bitmap(newSize.Width, newSize.Height);
        Graphics g = Graphics.FromImage(outBmp);

        // 设置画布的描绘质量
        g.CompositingQuality = CompositingQuality.HighQuality;
        g.SmoothingMode = SmoothingMode.HighQuality;
        g.InterpolationMode = InterpolationMode.HighQualityBicubic;

        g.DrawImage(img, new Rectangle(0, 0, newSize.Width, newSize.Height),
         0, 0, img.Width, img.Height, GraphicsUnit.Pixel);
        g.Dispose();

        // 以下代码为保存图片时，设置压缩质量
        EncoderParameters encoderParams = new EncoderParameters();
        long[] quality = new long[1];
        quality[0] = 100;

        EncoderParameter encoderParam = new EncoderParameter(System.Drawing.Imaging.Encoder.Quality, quality);
        encoderParams.Param[0] = encoderParam;

        //获得包含有关内置图像编码解码器的信息的ImageCodecInfo 对象。
        ImageCodecInfo[] arrayICI = ImageCodecInfo.GetImageEncoders();
        ImageCodecInfo jpegICI = null;
        for (int x = 0; x < arrayICI.Length; x++)
        {
            if (arrayICI[x].FormatDescription.Equals("JPEG"))
            {
                jpegICI = arrayICI[x];//设置JPEG编码
                break;
            }
        }

        if (jpegICI != null)
        {
            outBmp.Save(newFile, jpegICI, encoderParams);
        }
        else
        {
            outBmp.Save(newFile, thisFormat);
        }

        img.Dispose();
        outBmp.Dispose();
    }


}