﻿<%@ WebService Language="C#" Class="InventoryClass_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class InventoryClass_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        InventoryClassDAL dal = new InventoryClassDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                if (dal.CheckHasChild(Convert.ToInt32(id)))
                {
                    return "存在子类，不允许删除！";
                }
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                //return e.Message;
                return "该分类可能已被使用，不允许删除！"; 
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public InventoryClass Get(string ic_id)
    {
        InventoryClassDAL dal = new InventoryClassDAL();
        return dal.Get(Convert.ToInt32(ic_id));
    }
    /// <summary>
    /// 保存
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string ic_id, string ic_code, string ic_name,string parent_id)
    {
        ic_code = ic_code.Trim();
        if (ic_code.Equals(""))
        {
            return "分类编码不可为空！";
        }
        ic_name = ic_name.Trim();
        if (ic_name.Equals(""))
        {
            return "分类名称不可为空！";
        }
        try
        {
            InventoryClassDAL dal = new InventoryClassDAL();
            if (!parent_id.Equals("") && !parent_id.Equals("0"))
            {

                InventoryClass parent = dal.Get(Convert.ToInt32(parent_id));

                if (!dal.CheckLikeParent(ic_code, parent.ic_code))
                {
                    return "分类编码与父级分类规则不一致!";
                }
            }
            InventoryClass m = new InventoryClass();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(ic_id));
            }
            m.ic_id = Convert.ToInt32(ic_id);
            
            m.ic_code = ic_code;
            m.ic_name = ic_name;
            if (!parent_id.Equals(""))
            {
                m.parent_id = Convert.ToInt32(parent_id);
            }
            else
            {
                m.parent_id = 0;
            }
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(ic_code))
                {
                    return "分类编码" + ic_code + "已存在！";
                }
                dal.Add(m);
            }
            //更新分类级次
            dal.FetchNodeAndUpdateLayer(0, 1);
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}