﻿<%@ WebService Language="C#" Class="IOType_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class IOType_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        IOTypeDAL dal = new IOTypeDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                if(dal.CheckHasChild(Convert.ToInt32(id))){
                    return "存在子收发类型，不允许删除！";
                }
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "该档案已被使用，不允许删除！";// e.Message;
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public IOType Get(string iot_id)
    {
        IOTypeDAL dal = new IOTypeDAL();
        return dal.Get(Convert.ToInt32(iot_id));
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string iot_id, string iot_code, string iot_name, 
        string parent_id,string iot_flag)
    {
        iot_name = iot_name.Trim();
        if (iot_name.Equals(""))
        {
            return "名称不可为空！";
        }
        try
        {
            IOTypeDAL dal = new IOTypeDAL();
            if (!parent_id.Equals("") && !parent_id.Equals("0"))
            {
                
                IOType parent = dal.Get(Convert.ToInt32(parent_id));
                
                if (!dal.CheckLikeParent(iot_code,parent.iot_code))
                {
                    return "编码与父级规则不一致!";
                }
            }
            IOType m = new IOType();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(iot_id));
            }
            m.iot_code = iot_code;
            m.iot_name = iot_name;
            m.iot_flag = Convert.ToInt32(iot_flag);
            if (!parent_id.Equals("") && !parent_id.Equals(""))
            {
                m.parent_id = Convert.ToInt32(parent_id);
            }
            else
            {
                m.parent_id = 0;
            }
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(iot_code))
                {
                    return "编码" + iot_code + "已存在！";
                }
                dal.Add(m);
            }
            //更新分类级次
            dal.FetchNodeAndUpdateLayer(0, 1);
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}