﻿<%@ WebService Language="C#" Class="Employee_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Employee_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        EmployeeDAL dal = new EmployeeDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "该员工可能已被使用，不允许删除！";
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public Employee Get(string ele_id)
    {
        EmployeeDAL dal = new EmployeeDAL();
        return dal.Get(Convert.ToInt32(ele_id));
    }
    /// <summary>
    /// 保存
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string ele_id, string ele_code, string ele_name, string dep_id,string dep_name,
        string uid, string username, string entry_date, string exit_date, 
        string position, string birthday, string sex, string native_place,
        string degree,string id_card_no,string office_phone,string cellphone,
        string home_phone,string email,string qq,string address,string kl,
        string sdefine1,string sdefine2,string sdefine3,string sdefine4,string sdefine5,
        string ndefine1,string ndefine2,string ndefine3,string ndefine4,string ndefine5)
    {
        ele_code = ele_code.Trim();
        if (ele_code.Equals(""))
        {
            return "员工编码不可为空！";
        }
        ele_name = ele_name.Trim();
        if (ele_name.Equals(""))
        {
            return "员工名称不可为空！";
        }
        if (dep_id.Trim().Equals(""))
        {
            return "请选择所在部门！";
        }
        if (username.Trim().Equals(""))
        {
            uid = "";
        }
        try
        {
            DepartmentDAL d_dal = new DepartmentDAL();
            EmployeeDAL dal = new EmployeeDAL();
            Employee m = new Employee();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(ele_id));
            }
            m.ele_code = ele_code;
            m.ele_name = ele_name;
            if (!dep_id.Equals(""))
            {
                m.dep_id = Convert.ToInt32(dep_id);
            }
            else
            {
                m.dep_id = 0;
            }
            m.uid = XTools.ObjectNullToInt(uid);
            m.entry_date = XTools.ObjectNullToDateTime(entry_date);
            m.exit_date = XTools.ObjectNullToDateTime(exit_date);
            m.position = position;
            if (!birthday.Equals(""))
            {
                m.birthday = Convert.ToDateTime(birthday);
            }
            
            m.sex = Convert.ToInt32(sex);
            m.native_place = native_place;
            m.degree = degree;
            m.id_card_no = id_card_no;
            m.office_phone = office_phone;
            m.cellphone = cellphone;
            m.home_phone = home_phone;
            m.email = email;
            m.qq = qq;
            m.address = address;
            m.kl = XTools.ObjectNullToDecimal(kl);
            m.sdefine1 = sdefine1;
            m.sdefine2 = sdefine2;
            m.sdefine3 = sdefine3;
            m.sdefine4 = sdefine4;
            m.sdefine5 = sdefine5;

            m.ndefine1 = XTools.ObjectNullToDecimal(ndefine1);
            m.ndefine2 = XTools.ObjectNullToDecimal(ndefine2);
            m.ndefine3 = XTools.ObjectNullToDecimal(ndefine3);
            m.ndefine4 = XTools.ObjectNullToDecimal(ndefine4);
            m.ndefine5 = XTools.ObjectNullToDecimal(ndefine5);

            if (d_dal.CheckHasChild(Convert.ToInt32(m.dep_id)))
            {
                return "非末级部门，不允许增加员工！";
            }
            
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(ele_code))
                {
                    return "员工编码" + ele_code + "已存在！";
                }
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}