﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Employee_List.aspx.cs" Inherits="Base_Employee_Employee_List" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/ListHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript">
        var category = "";
        //搜索
        function search_grid() {
            var fg = document.getElementById("frame_grid");
            var ele_code = $("#ele_code").val();
            var ele_name = $("#ele_name").val();
            var url = "Employee_List_Grid.aspx?category=" + category + "&ele_code=" + ele_code + "&ele_name=" + ele_name;
            fg.src = url;
        }
        //加载树
        function load_tree() {
            var ft = document.getElementById("frame_tree");
            ft.src = "../Department/Department_Tree.aspx";
        }
        //新增
        function add() {
            asyncbox.open({
                id: 'win_modify',
                url: 'Employee_Edit.aspx?action=Add&category=' + category,
                modal:true,
                title:'新增'
	        });
        }
        //修改
        function modify() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._ele_id); //返回一维数组

            if (id.length == 0) {
                AlertNO('请选择要查看的记录!');
                return;
            }
            if (id.length > 1) {
                AlertNO('一次只可以查看一条记录!');
                return;
            }
            asyncbox.open({
                id: 'win_modify',
                url: 'Employee_Edit.aspx?action=Update&id=' + id,
                modal: true,
                title: '修改'
            });
            
        }
        //删除
        function del() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._ele_id);//返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要删除的记录!');
                return;
            }
            asyncbox.confirm('确定要删除吗', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: "Employee_Service.asmx/Delete",
                        data: "{ids:'" + id + "'}",
                        dataType: 'json',
                        success: function (result) {
                            var r = result.d;
                            if (r == "success") {
                                AlertOK('删除成功!');
                                load_tree();
                                search_grid();
                            } else {
                                AlertNO(r);
                            }
                            HideLoadingMask(); //关闭遮罩
                        }
                    });
                }
            });
        }
        //导入Excel
        function import_excel() {
            asyncbox.open({
                id: 'win_modify',
                url: '../ImportExcel/Import_Employee.aspx',
                modal: true,
                title: '导入Excel'
            });
        }
        //选择打印模板
        function grf_print() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            choice_print_template('<%=xview["auth_code"]%>', "", cw.sql_print_detail_session_id);
        }
        //分配下级
        function give_child() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._ele_id);//返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要分配下级的员工!');
                return;
            }
            if (id.length > 1) {
                AlertNO('一次只可以选择一个上级员工!');
                return;
            }
            asyncbox.open({
                id: 'win_give_child',
                url: 'GiveChild_List.aspx?parent_ele_id=' + id,
                width: 800,
                height:500,
                modal: true,
                title: '分配下级'
            });
        }
    </script>
</head>
<body onload="search_grid();load_tree();">
    <div class="div_frame_tree">
        <!--Tree控件所在的iframe-->
        <iframe  scrolling="auto" id="frame_tree" frameborder="0" style="width:100%;height:98%;"></iframe>
    </div>
    <div class="div_frame_grid">
        <!--工具栏-->
        <div style="height:30px;" class="list_menu_bar">
            <a plain="true" class="easyui-linkbutton" onclick="$('#search_win').window('open')" iconcls="icon-search">搜索</a>
            <a plain="true" class="easyui-linkbutton" onclick="add()" style='<%=auth.AuthView("Base_Employee_Edit")%>'>新增</a>
            <a plain="true" class="easyui-linkbutton" onclick="modify()">查看</a>
            <a plain="true" class="easyui-linkbutton" onclick="del()" style='<%=auth.AuthView("Base_Employee_Delete")%>'>删除</a>
            <a plain="true" class="easyui-linkbutton" id="btn_print" onclick='grf_print()'>打印</a>
            <a plain="true" class="easyui-linkbutton" onclick="DesignModuleFormat('Base_Employee_List')" style='<%=auth.FormatView()%>'>格式</a>
            <a plain="true" id="m_advanced" class="easyui-menubutton" menu="#menu_more_fun">更多功能</a>
        </div>
        <!--Grid控件所在的iframe-->
        <iframe id="frame_grid" frameborder="0" style="width:100%;height:98%" scrolling="no"></iframe>
    </div>
    <!--更多功能菜单-->
    <div id="menu_more_fun" style="width:150px;">
        <div onclick="import_excel()" style='<%=auth.AuthView("Base_Employee_Import")%>'>导入</div>
        <div onclick="give_child()" style=''>分配下级</div>
	</div>
    <!--搜索窗口-->  
	<div id="search_win" class="easyui-dialog" title="搜索"
        data-options="modal:true,closed:true,iconCls:'icon-search'"
        style="width:400px;height:300px;padding:10px;">
		<table style="margin:auto;">
            <tr>
                <td style="text-align:right">员工编码:</td>
                <td><input type="text" class="edit_text_box" id="ele_code"/></td>
            </tr>
            <tr>
                <td style="text-align:right">员工名称:</td>
                <td><input type="text" class="edit_text_box" id="ele_name"/></td>
            </tr>
		</table>
        <div style="margin-top:20px;text-align:center">
            <a href="javascript:search_grid()" class="easyui-linkbutton" onclick="javascript:$('#search_win').dialog('close')">搜索</a>
		    <a class="easyui-linkbutton" onClick="javascript:$('#search_win').dialog('close')">取消</a>
        </div>
	</div>
    <!--end of 搜索窗口--> 
</body>
</html>
