﻿<%@ WebService Language="C#" Class="Config_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Config_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        ConfigDAL dal = new ConfigDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "该档案已被使用，不允许删除！";// e.Message;
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public Config Get(string cf_code)
    {
        ConfigDAL dal = new ConfigDAL();
        return dal.GetByCode(cf_code);
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string digit_quantity, string digit_number, string digit_unit_price, string digit_exch)
    {
        digit_quantity = digit_quantity.Trim();
        digit_number = digit_number.Trim();
        digit_unit_price = digit_unit_price.Trim();
        digit_exch = digit_exch.Trim();
        if (digit_quantity.Equals("") || digit_number.Equals("") || digit_unit_price.Equals("") || digit_exch.Equals(""))
        {
            return "小数位数不可为空！";
        }
        if(!XTools.IsPositiveInt(digit_quantity)){
            return "数量小数位必须为正整数!";
        }
        if (!XTools.IsPositiveInt(digit_number))
        {
            return "件数小数位必须为正整数!";
        }
        if (!XTools.IsPositiveInt(digit_unit_price))
        {
            return "单价小数位必须为正整数!";
        }
        if (!XTools.IsPositiveInt(digit_exch))
        {
            return "换算率小数位必须为正整数!";
        }
        try
        {
            ConfigDAL dal = new ConfigDAL();

            Config m = new Config();
            m = dal.GetByCode("digit_quantity");
            m.cf_value = digit_quantity;
            dal.Update(m);
            m = new Config();
            m = dal.GetByCode("digit_number");
            m.cf_value = digit_number;
            dal.Update(m);
            m = new Config();
            m = dal.GetByCode("digit_unit_price");
            m.cf_value = digit_unit_price;
            dal.Update(m);
            m = new Config();
            m = dal.GetByCode("digit_exch");
            m.cf_value = digit_exch;
            dal.Update(m);
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}