﻿<%@ WebService Language="C#" Class="Department_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Department_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        DepartmentDAL dal = new DepartmentDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                if(dal.CheckHasChild(Convert.ToInt32(id))){
                    return "存在子部门，不允许删除！";
                }
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "该部门可能已被使用，不允许删除！";
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public Department Get(string dep_id)
    {
        DepartmentDAL dal = new DepartmentDAL();
        return dal.Get(Convert.ToInt32(dep_id));
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string dep_id, string dep_code, string dep_name,
        string parent_id, string is_workshop, string is_stop, string dep_wh_id, string dep_wh_name, 
        string sdefine1, string sdefine2, string sdefine3, string sdefine4, string sdefine5,
        string ndefine1, string ndefine2, string ndefine3, string ndefine4, string ndefine5)
    {
        dep_name = dep_name.Trim();
        if (dep_name.Equals(""))
        {
            return "部门名称不可为空！";
        }
        if (dep_wh_name.Equals(""))
        {
            dep_wh_id = "";
        }
        if (ndefine1.Equals("")) ndefine1 = null;
        if (ndefine2.Equals("")) ndefine2 = null;
        if (ndefine3.Equals("")) ndefine3 = null;
        if (ndefine4.Equals("")) ndefine4 = null;
        if (ndefine5.Equals("")) ndefine5 = null;
        try
        {
            DepartmentDAL dal = new DepartmentDAL();
            if (!parent_id.Equals("") && !parent_id.Equals("0"))
            {
                
                Department parent = dal.Get(Convert.ToInt32(parent_id));
                
                if (!dal.CheckLikeParent(dep_code,parent.dep_code))
                {
                    return "部门编码与父级部门规则不一致!";
                }
            }
            Department m = new Department();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(dep_id));
            }
            m.dep_code = dep_code;
            m.dep_name = dep_name;
            if (!parent_id.Equals("") && !parent_id.Equals(""))
            {
                m.parent_id = Convert.ToInt32(parent_id);
            }
            else
            {
                m.parent_id = 0;
            }
            m.is_workshop = Convert.ToInt32(is_workshop);
            m.is_stop = Convert.ToInt32(is_stop);
            m.dep_wh_id = XTools.ObjectNullToInt(dep_wh_id);
            m.sdefine1 = sdefine1;
            m.sdefine2 = sdefine2;
            m.sdefine3 = sdefine3;
            m.sdefine4 = sdefine4;
            m.sdefine5 = sdefine5;
            m.ndefine1 = Convert.ToDecimal(ndefine1);
            m.ndefine2 = Convert.ToDecimal(ndefine2);
            m.ndefine3 = Convert.ToDecimal(ndefine3);
            m.ndefine4 = Convert.ToDecimal(ndefine4);
            m.ndefine5 = Convert.ToDecimal(ndefine5);

            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(dep_code))
                {
                    return "部门编码" + dep_code + "已存在！";
                }
                dal.Add(m);
            }
            //更新分类级次
            dal.FetchNodeAndUpdateLayer(0, 1);
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}