﻿<%@ WebService Language="C#" Class="Customer_FollowUp_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Customer_FollowUp_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        Customer_FollowUpDAL dal = new Customer_FollowUpDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch(Exception e)
            {
                return "删除失败！"+e.Message;
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public Customer_FollowUp Get(string cfu_id)
    {
        Customer_FollowUpDAL dal = new Customer_FollowUpDAL();
        return dal.Get(Convert.ToInt32(cfu_id));
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string cfu_id, string cus_id, string fu_date,string remark)
    {
        cus_id = cus_id.Trim();
        if (cus_id.Equals(""))
        {
            return "客户不可为空！";
        }
        fu_date = fu_date.Trim();
        if (fu_date.Equals(""))
        {
            return "跟进日期不可为空！";
        }

        try
        {
            Customer_FollowUpDAL dal = new Customer_FollowUpDAL();
            Customer_FollowUp m = new Customer_FollowUp();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(cfu_id));
            }
            m.cus_id=Convert.ToInt32(cus_id);
            m.fu_date = Convert.ToDateTime(fu_date);
            LoginInfo li = new LoginInfo();
            m.fu_uid = li.uid;
            m.fu_user = li.nickname;
            m.remark = remark;
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}