﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Customer_FollowUp_List.aspx.cs" Inherits="Base_Customer_FollowUp_Customer_FollowUp_List" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/ListHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html>
<head>
    <title></title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript">
        var cus_id = '<%=Request["cus_id"]%>';
        //搜索
        function search_grid() {
            var fg = document.getElementById("frame_grid");
            var keyword = $("#keyword").val();
            var fu_code = $("#fu_code").val();
            var fu_name = $("#fu_name").val();
            var url = "Customer_FollowUp_List_Grid.aspx?keyword=" + keyword + "&cus_id=" + escape(cus_id);
            fg.src = url;
        }
        //新增
        function add() {
            asyncbox.open({
                id: 'win_modify',
                url: 'Customer_FollowUp_Edit.aspx?action=Add&cus_id=' + cus_id,
                modal:true,
                title:'新增'
	        });
        }
        //修改
        function modify() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._cfu_id); //返回一维数组

            if (id.length == 0) {
                AlertNO('请选择要查看的记录!');
                return;
            }
            if (id.length > 1) {
                AlertNO('一次只可以查看一条记录!');
                return;
            }
            asyncbox.open({
                id: 'win_modify',
                url: 'Customer_FollowUp_Edit.aspx?action=Update&id=' + id+'&cus_id=' + cus_id,
                modal: true,
                title: '修改'
            });
            
        }
        //删除
        function del() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._cfu_id);//返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要删除的记录!');
                return;
            }
            asyncbox.confirm('确定要删除吗', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: "Customer_FollowUp_Service.asmx/Delete",
                        data: "{ids:'" + id + "'}",
                        dataType: 'json',
                        success: function (result) {
                            var r = result.d;
                            if (r == "success") {
                                AlertOK('删除成功!');
                                search_grid();
                            } else {
                                AlertNO(r);
                            }
                            HideLoadingMask(); //关闭遮罩
                        }
                    });
                }
            });
        }
        
    </script>
</head>
<body onload="search_grid();">
    <!--工具栏-->
    <div style="height:30px;" class="list_menu_bar">
        <input type="text" class="keyword_box" id="keyword"/>
        <a plain="true" class="easyui-linkbutton" onclick="search_grid()">搜索</a>
        <a plain="true" class="easyui-linkbutton" onclick="add()" style='<%=auth.AuthView("Base_Customer_Edit")%>'>新增</a>
        <a plain="true" class="easyui-linkbutton" onclick="modify()">查看</a>
        <a plain="true" class="easyui-linkbutton" onclick="del()" style='<%=auth.AuthView("Base_Customer_Edit")%>'>删除</a>
        <a plain="true" class="easyui-linkbutton" onclick="DesignModuleFormat('Base_Customer_FollowUp_List')" style='<%=auth.FormatView()%>'>格式</a>
    </div>
    <!--Grid控件所在的iframe-->
    <%=xview["grid_frame"]%>
    <script type="text/javascript">
        $(document).ready(function () {
            $F("keyword").focus();
            $F("keyword").onkeypress = function (evt) {
                evt = evt ? evt : (window.event ? window.event : null);
                if (evt.keyCode == "13") {
                    search_grid();
                }
            }
        });
    </script>
</body>
</html>
