﻿<%@ WebService Language="C#" Class="Customer_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Customer_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        CustomerDAL dal = new CustomerDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "该客户可能已被使用，不允许删除！";
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public Customer Get(string cus_id)
    {
        CustomerDAL dal = new CustomerDAL();
        return dal.Get(Convert.ToInt32(cus_id));
    }
    /// <summary>
    /// 保存
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string cus_id, string cus_code, string cus_name, string cc_id,
        string is_stop, string bao_bei, string cus_full_name, string ship_address,
        string contact,string legal_person,string phone,string cellphone,string fax,
        string bank_of_deposit, string banking_account, string email, string qq, 
        string address, string ele_id, string ele_name,
        string sdefine1,string sdefine2,string sdefine3,string sdefine4,string sdefine5,
        string ndefine1,string ndefine2,string ndefine3,string ndefine4,string ndefine5)
    {
        try
        {
            cus_code = cus_code.Trim();
            if (cus_code.Equals("") && bao_bei.Equals("0"))
            {
                return "客户编码不可为空！";
            }
            cus_name = cus_name.Trim();
            if (cus_name.Equals(""))
            {
                return "客户名称不可为空！";
            }
            if (cc_id.Equals("") || cc_id.Equals("0"))
            {
                return "请选择客户分类！";
            }
            if (ele_name.Equals(""))
            {
                ele_id = "";
            }       
            CustomerDAL dal = new CustomerDAL();
            CustomerClassDAL pdal = new CustomerClassDAL();
            Customer m = new Customer();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(cus_id));
            }
            
            m.cus_code = cus_code;
            m.cus_name = cus_name;
            m.cc_id = Convert.ToInt32(cc_id);
            m.is_stop = XTools.ObjectNullToInt(is_stop);
            m.bao_bei = XTools.ObjectNullToInt(bao_bei);
            m.cus_full_name = cus_full_name;
            m.ship_address = ship_address;
            m.contact = contact;
            m.legal_person = legal_person;
            m.phone = phone;
            m.fax = fax;
            m.cellphone = cellphone;
            m.bank_of_deposit = bank_of_deposit;
            m.banking_account = banking_account;
            m.email = email;
            m.qq = qq;
            m.address = address;
            m.ele_id = XTools.ObjectNullToInt(ele_id);
            m.sdefine1 = sdefine1;
            m.sdefine2 = sdefine2;
            m.sdefine3 = sdefine3;
            m.sdefine4 = sdefine4;
            m.sdefine5 = sdefine5;
            m.ndefine1 = XTools.ObjectNullToDecimal(ndefine1);
            m.ndefine2 = XTools.ObjectNullToDecimal(ndefine2);
            m.ndefine3 = XTools.ObjectNullToDecimal(ndefine3);
            m.ndefine4 = XTools.ObjectNullToDecimal(ndefine4);
            m.ndefine5 = XTools.ObjectNullToDecimal(ndefine5);

            if (pdal.CheckHasChild(Convert.ToInt32(m.cc_id)))
            {
                return "非末级分类，不允许增加客户！";
            }
            
            if (action.Equals("Update"))
            {
                if (dal.CheckOtherCodeExist(cus_code, m.cus_id) && !cus_code.Equals(""))
                {
                    return "客户编码" + cus_code + "已存在！";
                }
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(cus_code) && !cus_code.Equals(""))
                {
                    return "客户编码" + cus_code + "已存在！";
                }
                if (dal.CheckCusNameExist(cus_name) && !cus_name.Equals(""))
                {
                    return "客户名称" + cus_name + "已存在！";
                }
                if (dal.CheckPhoneExist(phone) && !phone.Equals(""))
                {
                    return "客户电话" + phone + "已存在！";
                }
                if (dal.CheckCellPhoneExist(cellphone) && !cellphone.Equals(""))
                {
                    return "客户手机" + cellphone + "已存在！";
                }
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}