﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;
public partial class Base_Customer_Customer_List_Grid : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    AWGridFun aw = new AWGridFun();
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!Page.IsPostBack)
        {
            new LoginState().CheckLogin();
            CreateGrid();
        }
    }
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        //设置标题与样式
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        string sql_scusct_field = "";//SQL所需选择列
        string module = "Base_Customer_List";//模块
        string fields_index = "";//列索引
        mfd.CreateTitlesAndStyles(module, ref aw, ref sql_scusct_field, ref fields_index);
        xview.Add("fields_index", fields_index);
        //把样式传递到页面
        xview.Add("aw_column_style",aw.GetStyles());
        int page = 1;//当前页
        if (Request.QueryString["page"] != null)
            page = Convert.ToInt32(Request.QueryString["page"]);
        int page_size = aw.GetDefaultPageSize();//每页显示条数
        if (Request.QueryString["page_size"] != null)
            page_size = Convert.ToInt32(Request.QueryString["page_size"]);
        CustomerDAL dal = new CustomerDAL();
        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by cus_code asc";
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";
        if (!Request["cus_code"].Equals(""))
        {
            sql_end += " and cus_code like '%" + Request["cus_code"] + "%'";
        }
        if (!Request["cus_name"].Equals(""))
        {
            sql_end += " and cus_name like '%" + Request["cus_name"] + "%'";
        }
        if (!Request["category"].Equals("") && !Request["category"].Equals("0"))
        {
            string cc_code = new CustomerClassDAL().GetCodeById(Convert.ToInt32(Request["category"]));
            sql_end += " and cc_code like '" + cc_code + "%'";
        }
        if (!Request["ele_name"].Equals(""))
        {
            sql_end += " and ele_name like '%" + Request["ele_name"] + "%'";
        }
        if (!Request["bao_bei"].Equals(""))
        {
            if (Request["bao_bei"].Equals("1"))
            {
                sql_end += " and bao_bei_name='是'";
            }
            else
            {
                sql_end += " and bao_bei_name='否'";
            }
        }
        //当前用户是否管理员
        bool is_admin = new AuthUI().CheckLoginUserIsAdmin();
        if (!is_admin)
        {
            //值为1代表启用业务员权限控制
            string employee_auth = new ConfigReader().GetConfig("sale_employee_auth");
            if (employee_auth.Equals("1"))
            {
                sql_end += " and ele_id in (" + new AuthEx().GetSqlForMyEmployee() + ")";
            }
        }
        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = dal.GetList(ht, sql_scusct_field);
        //把sql放入session中供打印用
        string sql_print_detail_session_id = "sql_print_detail_Customer";
        Session[sql_print_detail_session_id] = dal.sql_print;
        xview.Add("sql_print_detail_session_id", sql_print_detail_session_id);
        //供导出Excel用
        string field_for_export = mfd.field_for_export;
        Session[sql_print_detail_session_id + "_export_field"] = field_for_export;
        //得到总记录数为分页提供依据
        int rows_count = dal.GetList_TotalNumbers(ht);
        string aw_grid_info = aw.MakeGridObject(dt, rows_count, page_size, page);
        //把控件参数与数据源传递到页面
        xview.Add("aw_grid_info", aw_grid_info);
    }
}
