﻿<%@ WebService Language="C#" Class="CustomerClass_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class CustomerClass_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        CustomerClassDAL dal = new CustomerClassDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                if (dal.CheckHasChild(Convert.ToInt32(id)))
                {
                    return "存在子类，不允许删除！";
                }
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "该分类可能已被使用，不允许删除！";
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public CustomerClass Get(string cc_id)
    {
        CustomerClassDAL dal = new CustomerClassDAL();
        return dal.Get(Convert.ToInt32(cc_id));
    }
    /// <summary>
    /// 保存
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string cc_id, string cc_code, string cc_name,string parent_id)
    {
        cc_code = cc_code.Trim();
        if (cc_code.Equals(""))
        {
            return "分类编码不可为空！";
        }
        cc_name = cc_name.Trim();
        if (cc_name.Equals(""))
        {
            return "分类名称不可为空！";
        }
        try
        {
            CustomerClassDAL dal = new CustomerClassDAL();
            if (!parent_id.Equals("") && !parent_id.Equals("0"))
            {

                CustomerClass parent = dal.Get(Convert.ToInt32(parent_id));

                if (!dal.CheckLikeParent(cc_code, parent.cc_code))
                {
                    return "分类编码与父级分类规则不一致!";
                }
            }
            CustomerClass m = new CustomerClass();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(cc_id));
            }
            m.cc_id = Convert.ToInt32(cc_id);
            m.cc_code = cc_code;
            m.cc_name = cc_name;
            if (!parent_id.Equals(""))
            {
                m.parent_id = Convert.ToInt32(parent_id);
            }
            else
            {
                m.parent_id = 0;
            }
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(cc_code))
                {
                    return "分类编码" + cc_code + "已存在！";
                }
                dal.Add(m);
            }
            //更新分类级次
            dal.FetchNodeAndUpdateLayer(0, 1);
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}