﻿<%@ WebService Language="C#" Class="CusInv_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class CusInv_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        CusInvDAL dal = new CusInvDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch(Exception err)
            {
                return "删除失败！具体错误：" + err.Message;
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public CusInv Get(string ci_id)
    {
        CusInvDAL dal = new CusInvDAL();
        return dal.Get(Convert.ToInt32(ci_id));
    }
    /// <summary>
    /// 保存
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string ci_id, string cus_id, string cus_code,
        string i_id,string i_code,string free1, string free2,
        string cus_i_name, string cus_price, string crc_id,string tax_rate,
        string sdefine1,string sdefine2,string sdefine3,string sdefine4,string sdefine5,
        string ndefine1,string ndefine2,string ndefine3,string ndefine4,string ndefine5)
    {
        try
        {
            cus_code = cus_code.Trim();
            if (cus_code.Equals(""))
            {
                return "客户不可为空！";
            }
            i_code = i_code.Trim();
            if (i_code.Equals(""))
            {
                return "存货不可为空！";
            }
     
            CusInvDAL dal = new CusInvDAL();
            CusInvDAL cus_dal = new CusInvDAL();
            CusInv m = new CusInv();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(ci_id));
            }

            m.cus_id = Convert.ToInt32(cus_id);
            m.i_id = Convert.ToInt32(i_id);
            free1 = free1.Trim();
            free2 = free2.Trim();
            cus_i_name = cus_i_name.Trim();
            m.crc_id = XTools.ObjectNullToInt(crc_id);
            m.cus_i_name = cus_i_name;
            m.cus_price = XTools.ObjectNullToDecimal(cus_price);
            m.tax_rate = XTools.ObjectNullToDecimal(tax_rate);
            m.sdefine1 = sdefine1;
            m.sdefine2 = sdefine2;
            m.sdefine3 = sdefine3;
            m.sdefine4 = sdefine4;
            m.sdefine5 = sdefine5;
            m.ndefine1 = XTools.ObjectNullToDecimal(ndefine1);
            m.ndefine2 = XTools.ObjectNullToDecimal(ndefine2);
            m.ndefine3 = XTools.ObjectNullToDecimal(ndefine3);
            m.ndefine4 = XTools.ObjectNullToDecimal(ndefine4);
            m.ndefine5 = XTools.ObjectNullToDecimal(ndefine5);

            
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                
                if (dal.CheckExist(Convert.ToInt32(cus_id), Convert.ToInt32(i_id), free1, free2, XTools.ObjectNullToInt(crc_id)))
                {
                    return "不允许存在相同客户+存货+币种的档案，请重新选择！";
                }
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}