﻿<%@ WebService Language="C#" Class="Currency_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Currency_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        CurrencyDAL dal = new CurrencyDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "该档案已被使用，不允许删除！";// e.Message;
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public Currency Get(string crc_id)
    {
        CurrencyDAL dal = new CurrencyDAL();
        return dal.Get(Convert.ToInt32(crc_id));
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string crc_id, string crc_code, string crc_name, 
        string is_standard)
    {
        crc_code = crc_code.Trim();
        if (crc_code.Equals(""))
        {
            return "币种编码不可为空！";
        }
        crc_name = crc_name.Trim();
        if (crc_name.Equals(""))
        {
            return "币种名称不可为空！";
        }
        try
        {
            CurrencyDAL dal = new CurrencyDAL();

            Currency m = new Currency();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(crc_id));
                if (dal.CheckNameExist(m.crc_name, crc_name))
                {
                    return "币种名称" + crc_name + "已存在！";
                }
            }
            int count_standard = dal.CountStandard(Convert.ToInt32(crc_id));
            if (is_standard.Equals("0"))
            {
                if (count_standard == 0)
                {
                    //return "至少得有一个币种必须是本位币！";
                }
            }
            if (is_standard.Equals("1"))
            {
                if (count_standard == 1)
                {
                    return "只允许存在一个本位币,请检查其它币种！";
                }
            }
            m.crc_code = crc_code;
            m.crc_name = crc_name;
            m.is_standard = Convert.ToInt32(is_standard);
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckCodeExist(crc_code))
                {
                    return "币种编码" + crc_code + "已存在！";
                }
                if (dal.CheckNameExist("", crc_name))
                {
                    return "币种名称" + crc_name + "已存在！";
                }
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
}