﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Currency_List.aspx.cs" Inherits="Base_Currency_Currency_List" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/ListHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript">
        //搜索
        function search_grid() {
            
            var fg = document.getElementById("frame_grid");
            var crc_code = $("#crc_code").val();
            var crc_name = $("#crc_name").val();
            var url = "Currency_List_Grid.aspx?crc_code=" + crc_code + "&crc_name=" + crc_name;
            fg.src = url;
        }
        //新增
        function add() {
            asyncbox.open({
                id: 'win_modify',
	            url: 'Currency_Edit.aspx?action=Add',
                modal:true,
                title:'新增'
	        });
        }
        //修改
        function modify() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var id = cw.aw_GetSelectRows(cw._crc_id); //返回一维数组

            if (id.length == 0) {
                AlertNO('请选择要查看的记录!');
                return;
            }
            if (id.length > 1) {
                AlertNO('一次只可以查看一条记录!');
                return;
            }
            asyncbox.open({
                id: 'win_modify',
                url: 'Currency_Edit.aspx?action=Update&id=' + id,
                modal: true,
                title: '修改'
            });
        }
        //删除
        function del() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._crc_id);//返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要删除的记录!');
                return;
            }
            asyncbox.confirm('确定要删除吗', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: "Currency_Service.asmx/Delete",
                        data: "{ids:'" + id + "'}",
                        dataType: 'json',
                        success: function (result) {
                            var r = result.d;
                            if (r == "success") {
                                AlertOK('删除成功!');
                                search_grid();
                            } else {
                                AlertNO(r);
                            }
                            HideLoadingMask(); //关闭遮罩
                        }
                    });
                }
            });
        }
        //编辑汇率
        function edit_rate() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var id = cw.aw_GetSelectRows(cw._crc_id); //返回一维数组

            if (id.length == 0) {
                AlertNO('请选择要查看的记录!');
                return;
            }
            if (id.length > 1) {
                AlertNO('一次只可以查看一条记录!');
                return;
            }
            asyncbox.open({
                id: 'win_modify',
                url: 'CurrencyRate_List.aspx?crc_id=' + id,
                width: 800,
                height: 450,
                modal: true,
                title: '编辑汇率'
            });
        }
    </script>
</head>
<body onload="search_grid();">
    <!--工具栏-->
    <div style="height:30px;" class="list_menu_bar">
        <a plain="true" class="easyui-linkbutton" onclick="$('#search_win').window('open')" iconcls="icon-search">搜索</a>
        <a plain="true" class="easyui-linkbutton" onclick="add()" style='<%=auth.AuthView("Base_Currency_Edit")%>'>新增</a>
        <a plain="true" class="easyui-linkbutton" onclick="modify()">修改</a>
        <a plain="true" class="easyui-linkbutton" onclick="del()" style='<%=auth.AuthView("Base_Currency_Delete")%>'>删除</a>
        <a plain="true" class="easyui-linkbutton" onclick="edit_rate()">编辑汇率</a>
        <a plain="true" class="easyui-linkbutton" onclick="DesignModuleFormat('Base_Currency_List')" style='<%=auth.FormatView()%>'>格式</a>
    </div>
    <!--Grid控件所在的iframe-->
    <%=xview["grid_frame"]%>
    <!--搜索窗口-->  
	<div id="search_win" class="easyui-dialog" title="搜索"
        data-options="modal:true,closed:true,iconCls:'icon-search'"
        style="width:400px;height:300px;padding:10px;">
		<table style="margin:auto;">
            <tr>
                <td style="text-align:right">币种编码:</td>
                <td><input type="text" class="edit_text_box" id="crc_code"/></td>
            </tr>
            <tr>
                <td style="text-align:right">币种名称:</td>
                <td><input type="text" class="edit_text_box" id="crc_name"/></td>
            </tr>
		</table>
        <div style="margin-top:20px;text-align:center">
            <a href="javascript:search_grid()" class="easyui-linkbutton" onclick="javascript:$('#search_win').dialog('close')">搜索</a>
		    <a class="easyui-linkbutton" onClick="javascript:$('#search_win').dialog('close')">取消</a>
        </div>
	</div>
    <!--end of 搜索窗口--> 
</body>
</html>
