﻿<%@ WebService Language="C#" Class="CurrencyRate_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class CurrencyRate_Service : System.Web.Services.WebService
{
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        CurrencyRateDAL dal = new CurrencyRateDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public CurrencyRate Get(string rate_id)
    {
        CurrencyRateDAL dal = new CurrencyRateDAL();
        return dal.Get(Convert.ToInt32(rate_id));
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string rate_id, string crc_id,
        string crc_year, string crc_month, string exchange_rate)
    {
        crc_year = crc_year.Trim();
        if (crc_year.Equals(""))
        {
            return "年份不可为空！";
        }
        crc_month = crc_month.Trim();
        if (crc_month.Equals(""))
        {
            return "月份不可为空！";
        }
        if(crc_year.Length != 4){
            return "年份格式不对！";
        }
        if (crc_month.Length > 2 || crc_month == "0")
        {
            return "月份格式不对！";
        }
        if (exchange_rate.Trim().Equals(""))
        {
            return "当前汇率不可为空，否则请填1！";
        }
        if (crc_id.Equals("") || crc_id.Equals("0"))
        {
            return "得不到币种id";
        }
        try
        {
            CurrencyRateDAL dal = new CurrencyRateDAL();
            CurrencyRate m = new CurrencyRate();

            m.crc_id = Convert.ToInt32(crc_id);
            m.rate_id = Convert.ToInt32(rate_id);
            m.crc_year = Convert.ToInt32(crc_year);
            m.crc_month = Convert.ToInt32(crc_month);
            m.exchange_rate = Convert.ToDecimal(exchange_rate);
            if (m.crc_month > 12 || m.crc_month < 1)
            {
                return "月份不允许小于1月或大于12月！";
            }
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckRateExist(m.crc_id, m.crc_year, m.crc_month))
                {
                    return "该月份汇率已存在！";
                }
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
}