﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="CurrencyRate_List.aspx.cs" Inherits="Base_Currency_CurrencyRate_List" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/ListHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript">
        var crc_id = '<%=Request["crc_id"].ToString() %>';
        //搜索
        function search_grid() {
            var fg = document.getElementById("frame_grid");
            var url = "CurrencyRate_List_Grid.aspx?crc_id=" + crc_id;
            fg.src = url;
        }
        //新增
        function add() {
            asyncbox.open({
                id: 'win_add',
                url: 'CurrencyRate_Edit.aspx?action=Add&crc_id=' + crc_id,
                modal:true,
                title:'新增'
	        });
        }
        //修改
        function modify() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var id = cw.aw_GetSelectRows(cw._rate_id); //返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要查看的记录!');
                return;
            }
            if (id.length > 1) {
                AlertNO('一次只可以查看一条记录!');
                return;
            }
            asyncbox.open({
                id: 'win_modify',
                url: 'CurrencyRate_Edit.aspx?action=Update&id=' + id + "&crc_id=" + crc_id,
                modal: true,
                title: '修改'
            });
            
        }
        //删除
        function del() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var id = cw.aw_GetSelectRows(cw._rate_id); //返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要删除的记录!');
                return;
            }
            asyncbox.confirm('确定要删除吗', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: "CurrencyRate_Service.asmx/Delete",
                        data: "{ids:'" + id + "'}",
                        dataType: 'json',
                        success: function (result) {
                            var r = result.d;
                            if (r == "success") {
                                AlertOK('删除成功!');
                                search_grid();
                            } else {
                                AlertNO(r);
                            }
                            HideLoadingMask(); //关闭遮罩
                        }
                    });
                }
            });
        }
        
    </script>
</head>
<body onload="search_grid();">
    <!--工具栏-->
    <div style="height:30px;" class="list_menu_bar">
        <a plain="true" class="easyui-linkbutton" onclick="add()" style='<%=auth.AuthView("Base_Currency_Edit")%>'>新增</a>
        <a plain="true" class="easyui-linkbutton" onclick="modify()" style='<%=auth.AuthView("Base_Currency_Edit")%>'>修改</a>
        <a plain="true" class="easyui-linkbutton" onclick="del()" style='<%=auth.AuthView("Base_Currency_Edit")%>'>删除</a>
        <a plain="true" class="easyui-linkbutton" onclick="DesignModuleFormat('Base_CurrencyRate_List')" style='<%=auth.FormatView()%>'>格式</a>
    </div>
    <!--Grid控件所在的iframe-->
    <%=xview["grid_frame"]%>
</body>
</html>
