﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using SysCore;
using SysCore.Control;
using SysCore.Model;
using SysCore.DAL;

public partial class Base_Currency_CurrencyRate_Edit : System.Web.UI.Page
{
    public AuthUI auth = new AuthUI();
    public CurrencyRate m;
    public string action;
    public Hashtable xview = new Hashtable();
    protected void Page_Load(object sender, EventArgs e)
    {
        action = Request["action"].ToString();
        xview.Add("action", action);
        //update为修改状态
        if (action.Equals("Add"))
        {
            DateTime dt = DateTime.Parse(new LoginInfo().login_date);
            xview.Add("crc_year",dt.Year);
            xview.Add("crc_month", dt.Month);
        }
        BindData();
    }
    /// <summary>
    /// 绑定页面数据
    /// </summary>
    void BindData()
    {
        int rate_id = Convert.ToInt32(Request["id"]);
        
        CurrencyRateDAL dal = new CurrencyRateDAL();
        m = dal.Get(rate_id);
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        InputUI ui = new InputUI();
        string sql_select_field = "";//SQL所需选择列
        string module = "Base_CurrencyRate_Input";//模块
        mfd.CreateInput(module, ref ui, ref sql_select_field, m);
        xview.Add("input_ui", ui.CreateUI());
        Hashtable ht_js = mfd.MakeJavaScript_GetInput(module);
        xview.Add("Script_GetInput", ht_js["Script_GetInput"].ToString());
        xview.Add("Script_SaveJSON", ht_js["Script_SaveJSON"].ToString());
    }
}