﻿<%@ WebService Language="C#" Class="Cost_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Cost_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        CostDAL dal = new CostDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                if(dal.CheckHasChild(Convert.ToInt32(id))){
                    return "存在子费用，不允许删除！";
                }
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "该费用可能已被使用，不允许删除！";
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public Cost Get(string cst_id)
    {
        CostDAL dal = new CostDAL();
        return dal.Get(Convert.ToInt32(cst_id));
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string cst_id, string cst_code, string cst_name, 
        string parent_id,  string is_stop,
        string sdefine1, string sdefine2, string sdefine3, string sdefine4, string sdefine5,
        string ndefine1, string ndefine2, string ndefine3, string ndefine4, string ndefine5)
    {
        cst_name = cst_name.Trim();
        if (cst_name.Equals(""))
        {
            return "费用名称不可为空！";
        }
        if (ndefine1.Equals("")) ndefine1 = null;
        if (ndefine2.Equals("")) ndefine2 = null;
        if (ndefine3.Equals("")) ndefine3 = null;
        if (ndefine4.Equals("")) ndefine4 = null;
        if (ndefine5.Equals("")) ndefine5 = null;
        try
        {
            CostDAL dal = new CostDAL();
            if (!parent_id.Equals("") && !parent_id.Equals("0"))
            {
                
                Cost parent = dal.Get(Convert.ToInt32(parent_id));
                
                if (!dal.CheckLikeParent(cst_code,parent.cst_code))
                {
                    return "费用编码与父级费用规则不一致!";
                }
            }
            Cost m = new Cost();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(cst_id));
            }
            m.cst_code = cst_code;
            m.cst_name = cst_name;
            if (!parent_id.Equals("") && !parent_id.Equals(""))
            {
                m.parent_id = Convert.ToInt32(parent_id);
            }
            else
            {
                m.parent_id = 0;
            }
            m.is_stop = Convert.ToInt32(is_stop);
            m.sdefine1 = sdefine1;
            m.sdefine2 = sdefine2;
            m.sdefine3 = sdefine3;
            m.sdefine4 = sdefine4;
            m.sdefine5 = sdefine5;
            m.ndefine1 = Convert.ToDecimal(ndefine1);
            m.ndefine2 = Convert.ToDecimal(ndefine2);
            m.ndefine3 = Convert.ToDecimal(ndefine3);
            m.ndefine4 = Convert.ToDecimal(ndefine4);
            m.ndefine5 = Convert.ToDecimal(ndefine5);

            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(cst_code))
                {
                    return "费用编码" + cst_code + "已存在！";
                }
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}