﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Cost_List.aspx.cs" Inherits="Base_Cost_Cost_List" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/ListHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript">
        var category = "";
        //搜索
        function search_grid() {
            var fg = document.getElementById("frame_grid");
            var cst_code = $("#cst_code").val();
            var cst_name = $("#cst_name").val();
            var url = "Cost_List_Grid.aspx?category=" + category + "&cst_code=" + cst_code + "&cst_name=" + cst_name;
            fg.src = url;
        }
        //加载树
        function load_tree() {
            var ft = document.getElementById("frame_tree");
            ft.src = "Cost_Tree.aspx";
        }
        //新增
        function add() {
            asyncbox.open({
                id: 'win_modify',
	            url: 'Cost_Edit.aspx?action=Add&parent_id='+category,
                modal:true,
                title:'新增'
	        });
        }
        //修改
        function modify() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._cst_id); //返回一维数组

            if (id.length == 0) {
                AlertNO('请选择要查看的记录!');
                return;
            }
            asyncbox.open({
                id: 'win_modify',
                url: 'Cost_Edit.aspx?action=Update&id=' + id,
                modal: true,
                title: '修改'
            });
            
        }
        //删除
        function del() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var data = fg.aw_myData;
            var id = cw.aw_GetSelectRows(cw._cst_id);//返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要删除的记录!');
                return;
            }
            asyncbox.confirm('确定要删除吗', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: "Cost_Service.asmx/Delete",
                        data: "{ids:'" + id + "'}",
                        dataType: 'json',
                        success: function (result) {
                            var r = result.d;
                            if (r == "success") {
                                AlertOK('删除成功!');
                                load_tree();
                                search_grid();
                            } else {
                                AlertNO(r);
                            }
                            HideLoadingMask(); //关闭遮罩
                        }
                    });
                }
            });
        }
        
    </script>
</head>
<body onLoad="search_grid();load_tree();">
    <div class="div_frame_tree">
        <!--Tree控件所在的iframe-->
        <iframe  scrolling="auto" id="frame_tree" frameborder="0" style="width:100%;height:98%;"></iframe>
    </div>
    <div class="div_frame_grid">
        <!--工具栏-->
        <div style="height:30px;" class="list_menu_bar">
            <a plain="true" class="easyui-linkbutton" onClick="$('#search_win').window('open')" iconcls="icon-search">搜索</a>
            <a plain="true" class="easyui-linkbutton" onClick="add()">新增</a>
            <a plain="true" class="easyui-linkbutton" onClick="modify()">修改</a>
            <a plain="true" class="easyui-linkbutton" onClick="del()">删除</a>
            <a plain="true" class="easyui-linkbutton" onClick="DesignModuleFormat('Base_Cost_List')">格式</a>
        </div>
        <!--Grid控件所在的iframe-->
        <iframe id="frame_grid" frameborder="0" style="width:100%;height:100%" scrolling="no"></iframe>
    </div>
    <!--搜索窗口-->  
	<div id="search_win" class="easyui-dialog" title="搜索"
        data-options="modal:true,closed:true,iconCls:'icon-search'"
        style="width:400px;height:300px;padding:10px;">
		<table style="margin:auto;">
            <tr>
                <td style="text-align:right">部门编码:</td>
                <td><input type="text" class="edit_text_box" id="cst_code"/></td>
            </tr>
            <tr>
                <td style="text-align:right">部门名称:</td>
                <td><input type="text" class="edit_text_box" id="cst_name"/></td>
            </tr>
		</table>
        <div style="margin-top:20px;text-align:center">
            <a href="javascript:search_grid()" class="easyui-linkbutton" onClick="javascript:$('#search_win').dialog('close')">搜索</a>
		    <a class="easyui-linkbutton" onClick="javascript:$('#search_win').dialog('close')">取消</a>
        </div>
	</div>
    <!--end of 搜索窗口--> 
</body>
</html>
