﻿<%@ WebService Language="C#" Class="BOMs_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Transactions;
using SysCore;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class BOMs_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        BOMsDAL dal = new BOMsDAL();
        BOMDAL t_dal = new BOMDAL();
        BOM t = new BOM();

        foreach (string id in ids.Split(','))
        {
            int bo_id = dal.Get(Convert.ToInt32(id)).bo_id;
            t = t_dal.Get(bo_id);
            if (t.verify_uid != null)
            {
                return "已审核不允许删行";
            }
            try
            {
                BOMs m = dal.Get(Convert.ToInt32(id));
                dal.Delete(Convert.ToInt32(id));
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
    }

    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string bo_id, string bos_id,
        string d_wh_id, string d_wh_name, string d_dep_id, string d_dep_name,
        string i_id, string free1, string free2, string i_code, string i_name,
        string standard,string munit,string aunit,
        string bo_quantity, string bo_num, string convert_rate, string att_rate, string d_remark, 
        string d_sdefine1, string d_sdefine2, string d_sdefine3, string d_sdefine4, string d_sdefine5,
        string d_ndefine1, string d_ndefine2, string d_ndefine3, string d_ndefine4, string d_ndefine5)
    {
        if (d_dep_id == "0" || d_dep_name == "")
            d_dep_id = "";
        if (string.IsNullOrWhiteSpace(i_id) || i_id.Equals("0"))
        {
            return "请输入存货！";
        }
        if (string.IsNullOrWhiteSpace(bo_quantity) || bo_quantity.Equals("0"))
        {
            return "单件用量不可为空或零！";
        }

        try
        {
            BOMsDAL dal = new BOMsDAL();
            BOMs m = new BOMs();
            BOM io = new BOMDAL().Get(Convert.ToInt32(bo_id));
            if (io.verify_uid != null)
            {
                return "已审核不允许改单";
            }
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(bos_id));
            }
            try
            {
                if (d_wh_id.Equals("") || d_wh_id.Equals("0"))
                {
                    return "仓库不能为空！";
                }
                m.d_wh_id = XTools.ObjectNullToInt(d_wh_id);
                m.d_dep_id = XTools.ObjectNullToInt(d_dep_id);
                m.bo_id = Convert.ToInt32(bo_id);
                m.i_id = Convert.ToInt32(i_id);
                free1 = free1.Trim();
                free2 = free2.Trim();
                if (m.i_id == io.p_i_id)
                {
                    return "子件不允许和父件一样！";
                }
                Inventory inv = new InventoryDAL().Get(Convert.ToInt32(i_id));
                if (!free1.Equals("") && inv.on_free1 == 0)
                    return "存货不允许输入自由项1！";
                if (!free2.Equals("") && inv.on_free2 == 0)
                    return "存货不允许输入自由项2！";
                if (free1.Equals("") && inv.on_free1 == 1)
                    return "存货必须输入自由项1！";
                if (free2.Equals("") && inv.on_free2 == 1)
                    return "存货必须输入自由项2！";
                m.free1 = free1;
                m.free2 = free2;

                if (inv.aunit.Equals("") && !bo_num.Equals(""))
                    return "未启用辅计量单位，启不要输入件数！";
                if (!inv.aunit.Equals(""))
                {
                    if (bo_num.Equals("") || bo_num.Equals("0"))
                    {
                        return "存货启用了辅计量单位，必须输入件数！";
                    }
                    if (convert_rate.Equals("") || convert_rate.Equals("0"))
                    {
                        return "存货启用了辅计量单位，必须输入换算率！";
                    }
                }
                m.bo_quantity = XTools.ObjectNullToDecimal(bo_quantity);
                m.bo_num = XTools.ObjectNullToDecimal(bo_num);
                m.convert_rate = XTools.ObjectNullToDecimal(convert_rate);
                m.att_rate = XTools.ObjectNullToDecimal(att_rate);
                m.d_remark = XTools.ObjectNullToString(d_remark);
            }
            catch (Exception err)
            {
                return err.Message;
            }
            //启用事务
            using (TransactionScope scope = new TransactionScope())
            {
                if (action.Equals("Update"))
                {
                    //更新明细
                    dal.Update(m);
                }
                else
                {
                    //新增明细
                    dal.Add(m);
                }

                //提交事务
                scope.Complete();
            }
        }
        catch (Exception e)
        {
            return e.Message;
        }
        return "success";
    }
 
}