﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using SysCore.Control;
using SysCore.Model;
using SysCore.DAL;

public partial class Base_BOM_BOMs_Edit : System.Web.UI.Page
{
    public int id, did;
    public string action;
    public BOM tm;
    public BOMs m;
    public Hashtable xview = new Hashtable();
    protected void Page_Load(object sender, EventArgs e)
    {
        new LoginState().CheckLogin();
        action = Request["action"].ToString();
        xview.Add("action", action);
        BindData();
    }
    /// <summary>
    /// 绑定页面数据
    /// </summary>
    void BindData()
    {
        id = Convert.ToInt32(Request["id"]);
        did = Convert.ToInt32(Request["did"]);
        BOMsDAL dal = new BOMsDAL();
        m = dal.Get(did);
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        InputUI ui = new InputUI();
        string sql_select_field = "";//SQL所需选择列
        string module = "Base_BOMs_Input";//模块
        mfd.CreateInput(module, ref ui, ref sql_select_field, m);
        xview.Add("input_ui", ui.CreateUI());
        Hashtable ht_js = mfd.MakeJavaScript_GetInput(module);
        xview.Add("Script_GetInput", ht_js["Script_GetInput"].ToString());
        xview.Add("Script_SaveJSON", ht_js["Script_SaveJSON"].ToString());
        Config cf = new Config();
        ConfigDAL cf_dal = new ConfigDAL();
        xview.Add("digit_quantity", cf_dal.GetByCode("digit_quantity").cf_value);
        xview.Add("digit_number", cf_dal.GetByCode("digit_number").cf_value);
        xview.Add("digit_exch", cf_dal.GetByCode("digit_exch").cf_value);
        xview.Add("digit_unit_price", cf_dal.GetByCode("digit_unit_price").cf_value);
        tm = new BOMDAL().Get(id);
        InventoryPhoto ip = new InventoryPhoto();
        if (action.Equals("Update"))
        {
            ip = new InventoryPhotoDAL().GetByInventory(m.inventory.i_id);
        }
        if (ip.small_pic_url == null)
        {
            xview.Add("inventory_photo_view", ip.no_photo);
        }
        else
        {
            xview.Add("inventory_photo_view", ip.small_pic_url);
            xview.Add("inventory_photo_view_href", ip.pic_url);
        }
    }
}