﻿<%@ WebService Language="C#" Class="BOM_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Collections;
using System.Transactions;
using SysCore;

//using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class BOM_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 保存单据
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string bo_id, string p_i_id, string p_i_code,
        string new_date, string wh_id, string wh_name, 
        string dep_id, string dep_name,string remark,
        string sdefine1, string sdefine2, string sdefine3, string sdefine4, string sdefine5,
        string ndefine1, string ndefine2, string ndefine3, string ndefine4, string ndefine5)
    {
        if (string.IsNullOrWhiteSpace(new_date))
        {
            return "制单日期不可为空！";
        }
        if (string.IsNullOrWhiteSpace(p_i_id))
        {
            return "请选择父件！";
        }
        try
        {
            BOMDAL dal = new BOMDAL();
            BOM m = new BOM();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(bo_id));
                if (!m.p_i_id.ToString().Equals(p_i_id.ToString()))
                {
                    if (dal.CheckExist(p_i_id))
                    {
                        return "您修改了父件，然而父件：" + p_i_code + "已存在，请尝试别的父件！";
                    }
                }
            }
            LoginInfo li = new LoginInfo();
            try
            {
                m.new_date = Convert.ToDateTime(new_date);
                m.p_i_id = Convert.ToInt32(p_i_id);
                m.wh_id = XTools.ObjectNullToInt(wh_id);
                m.dep_id = XTools.ObjectNullToInt(dep_id);
                m.remark = remark.ToString();
                m.sdefine1 = sdefine1.ToString();
                m.sdefine2 = sdefine2.ToString();
                m.sdefine3 = sdefine3.ToString();
                m.sdefine4 = sdefine4.ToString();
                m.sdefine5 = sdefine5.ToString();
                m.ndefine1 = XTools.ObjectNullToDecimal(ndefine1);
                m.ndefine2 = XTools.ObjectNullToDecimal(ndefine2);
                m.ndefine3 = XTools.ObjectNullToDecimal(ndefine3);
                m.ndefine4 = XTools.ObjectNullToDecimal(ndefine4);
                m.ndefine5 = XTools.ObjectNullToDecimal(ndefine5);
            }
            catch (Exception err)
            {
                return err.Message;
            }
            if (action.Equals("Update"))
            {
                if (m.verify_uid != null)
                {
                    return "已审核不允许改单";
                }
                m.update_date = Convert.ToDateTime(li.login_date);
                m.update_uid = li.uid;
                m.update_user = li.nickname;
                try{
                    //更新表头
                    dal.Update(m);
                }
                catch (Exception err)
                {
                    return err.Message;
                }
            }
            else
            {
                //如果新增时单据号不为空说明是手工输入单号
                if (!p_i_id.Equals(""))
                {
                    if (dal.CheckExist(p_i_id))
                    {
                        return "父件：" + p_i_code + "已存在！";
                    }
                }
                m.new_uid = li.uid;
                m.new_user = li.nickname;
                //启用事务
                using (TransactionScope scope = new TransactionScope())
                {
                    try
                    {
                        //新增表头
                        dal.Add(m);
                    }
                    catch (Exception err)
                    {
                        return err.Message;
                    }
                    //得到新增保存后的最大ID号
                    int MaxID = dal.GetMaxID();
                    bo_id = MaxID.ToString();
                    //提交事务
                    scope.Complete();
                }
            }
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success|" + bo_id;
    }
    /// <summary>
    /// 删单
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        string prev_id = "";
        foreach (string fid in ids.Split(','))
        {
            int id = Convert.ToInt32(fid);
            BOMDAL dal = new BOMDAL();
            BOM bo = dal.Get(id);
            if (bo.verify_uid != null)
            {
                return "单据:" + bo.p_inventory.i_code + "已审核不允许删单!";
            }
            BOMsDAL sdal = new BOMsDAL();
            prev_id = GetPrevNextID(id, "1");//得到上一张单据ID
            string msg = "";
            //启用事务
            using (TransactionScope scope = new TransactionScope())
            {
                msg = dal.Delete(id);
                if (!msg.Equals("success"))
                {
                    return msg;
                }
                //提交事务
                scope.Complete();
            }
        }
        return "success|" + prev_id;
    }
    /// <summary>
    /// 检查
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Check(int id)
    {
        BOMDAL dal = new BOMDAL();
        BOM m = dal.Get(id);
        //检查必填项
        string result = dal.CheckMustInput(id);
        if (!result.Equals("success"))
        {
            return result;
        }
        if (!result.Equals("success"))
        {
            return result;
        }
        return "success";
    }
    /// <summary>
    /// 审核或弃审
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Verify(string id, int action_type)
    {
        foreach (string fid in id.Split(','))
        {
            int doc_id = Convert.ToInt32(fid);
            try
            {
                BOMDAL dal = new BOMDAL();
                BOM m = dal.Get(doc_id);
                LoginInfo li = new LoginInfo();
                if (action_type == 1)
                {
                    if (m.verify_uid != null)
                    {
                        return "不允许重复审核";
                    }
                    m.verify_uid = li.uid;
                    m.verify_user = li.nickname;
                    //审核前检查
                    string result = Check(doc_id);
                    if (!result.Equals("success"))
                    {
                        return result;
                    }
                }
                else
                {
                    if (m.verify_uid == null)
                    {
                        return "不允许重复弃审";
                    }
                    m.verify_uid = null;
                    m.verify_user = null;
                }
                //更新实体
                dal.Update(m);
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
        
    }
    
    /// <summary>
    /// 上张或下张
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="type">操作类型</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string GetPrevNextID(int id, string type)
    {
        BOMDAL dal = new BOMDAL();
        return dal.GetPrevNextID(id, type).ToString();
    }
    /// <summary>
    /// 批量设置表体仓库
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="wh_id">仓库id</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string BatchSetWarehouse(int id, int wh_id)
    {
        BOMDAL dal = new BOMDAL();
        try
        {
            if (dal.Get(id).verify_uid != null)
            {
                return "已审核不允许改单";
            }
            dal.BatchSetWarehouse(id, wh_id);
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }
    /// <summary>
    /// 批量设置表体部门
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="dep_id">部门id</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string BatchSetDepartment(int id, int dep_id)
    {
        BOMDAL dal = new BOMDAL();
        try
        {
            if (dal.Get(id).verify_uid != null)
            {
                return "已审核不允许改单";
            }
            dal.BatchSetDepartment(id, dep_id);
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }

}