﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;
public partial class Base_BOM_BOM_List_Grid : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    AWGridFun aw = new AWGridFun();
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!Page.IsPostBack)
        {
            CreateGrid();
        }
    }
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        //设置标题与样式
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        string sql_select_field = "";//SQL所需选择列
        string module = "Base_BOM_List";//模块
        string fields_index = "";//列索引
        mfd.CreateTitlesAndStyles(module, ref aw, ref sql_select_field, ref fields_index);
        xview.Add("fields_index", fields_index);
        //把样式传递到页面
        xview.Add("aw_column_style",aw.GetStyles());
        int page = 1;//当前页
        if (Request.QueryString["page"] != null)
            page = Convert.ToInt32(Request.QueryString["page"]);
        int page_size = aw.GetDefaultPageSize();//每页显示条数
        if (Request.QueryString["page_size"] != null)
            page_size = Convert.ToInt32(Request.QueryString["page_size"]);
        
        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by bo_id desc";
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";
        if (!Request["keyword"].Equals(""))
        {
            //要搜索关键字
            string keyword = Request["keyword"].ToString();
            //要搜索的字段
            string search_fields = @"p_i_code,
                    p_i_name,ic_id,ic_name,p_standard,p_munit,
                    sdefine1,sdefine2,sdefine3,sdefine4,sdefine5,
                    ndefine1,ndefine2,ndefine3,ndefine4,ndefine5,
                    d_inv_sdefine1,d_inv_sdefine2,d_inv_sdefine3,
                    d_inv_sdefine4,d_inv_sdefine5,
                    d_inv_ndefine1,d_inv_ndefine2,d_inv_ndefine3,
                    d_inv_ndefine4,d_inv_ndefine5,
                    remark,new_user,verify_user,update_user";
            sql_end = FastSearh.MakeSearchSqlForWhere(keyword, search_fields);
        }

        if (!Request["begin_date"].Equals(""))
        {
            sql_end += " and new_date>='" + Request["begin_date"] + "'";
        }
        if (!Request["end_date"].Equals(""))
        {
            sql_end += " and new_date<='" + Request["end_date"] + "'";
        }

        if (!Request["i_code"].Equals(""))
        {
            sql_end += " and p_i_code like '%" + Request["i_code"] + "%'";
        }
        if (!Request["i_name"].Equals(""))
        {
            sql_end += " and p_i_name like '%" + Request["i_name"] + "%'";
        }
        if (!Request["standard"].Equals(""))
        {
            sql_end += " and p_standard like '%" + Request["standard"] + "%'";
        }
        if (Request["is_verify"].Equals("0"))
        {
            sql_end += " and isnull(verify_user,'')=''";
        }
        if (Request["is_verify"].Equals("1"))
        {
            sql_end += " and isnull(verify_user,'')!=''";
        }
        if (!Request["ic_id"].Equals(""))
        {
            sql_end += " and isnull(ic_id,'')=" + Request["ic_id"] + "";
        }
        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = GetList(ht, sql_select_field);
        //把sql放入session中供打印用
        string sql_print_detail_session_id = "sql_print_detail_" + module;
        Session[sql_print_detail_session_id] = sql_print;
        xview.Add("sql_print_detail_session_id", sql_print_detail_session_id);
        //得到总记录数为分页提供依据
        int rows_count = GetList_TotalNumbers(ht);
        //开启合计行功能
        aw.to_sum_row = false;
        //从模板读出哪些列需要合计
        aw.last_row_info = mfd.last_row_info;
        string aw_grid_info = aw.MakeGridObject(dt, rows_count, page_size, page);
        //把控件参数与数据源传递到页面
        xview.Add("aw_grid_info", aw_grid_info);
    }
    //打印用的sql
    public string sql_print = "";
    //列表查询用的sql
    string sql_list = @"
                    select t.bo_id,t.p_i_id,
                    i.i_code as p_i_code,i.i_name as p_i_name,i.ic_id,ic.ic_name,
                    i.standard as p_standard,i.munit as p_munit,
                    convert(char(10),t.new_date,23) as new_date,
                    t.sdefine1,t.sdefine2,t.sdefine3,t.sdefine4,t.sdefine5,
                    t.ndefine1,t.ndefine2,t.ndefine3,t.ndefine4,t.ndefine5,
                    i.sdefine1 as d_inv_sdefine1,i.sdefine2 as d_inv_sdefine2,i.sdefine3 as d_inv_sdefine3,
                    i.sdefine4 as d_inv_sdefine4,i.sdefine5 as d_inv_sdefine5,
                    i.ndefine1 as d_inv_ndefine1,i.ndefine2 as d_inv_ndefine2,i.ndefine3 as d_inv_ndefine3,
                    i.ndefine4 as d_inv_ndefine4,i.ndefine5 as d_inv_ndefine5,
                    t.remark,t.new_user,t.verify_user,t.update_user,t.update_date
                    from Base_BOM t
                    left join Base_Inventory i on t.p_i_id=i.i_id
                    left join Base_InventoryClass ic on i.ic_id=ic.ic_id
                    where 1=1 ";
    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(@sql_list)t where 1=1 ";
        sql = sql.Replace("@sql_list", sql_list)
                 .Replace("@order_field", order_field)
                 .Replace("@sql_select_field", sql_select_field);
        sql_print = "select * from (" + sql_list + ") t where 1=1 " + pg["sql_end"] + " " + pg["order_field"].ToString();
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from (" + sql_list + ")t where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
}
