﻿<%@ WebService Language="C#" Class="Account_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Account_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        AccountDAL dal = new AccountDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch
            {
                return "删除失败！该结算账户可能已被使用。";
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public Account Get(string ac_id)
    {
        AccountDAL dal = new AccountDAL();
        return dal.Get(Convert.ToInt32(ac_id));
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string ac_id, string ac_code, string ac_name, string bank_name, string bank_no, string is_stop)
    {
        ac_code = ac_code.Trim();
        if (ac_code.Equals(""))
        {
            return "账户编码不可为空！";
        }
        ac_name = ac_name.Trim();
        if (ac_name.Equals(""))
        {
            return "账户名称不可为空！";
        }
        
        try
        {
            AccountDAL dal = new AccountDAL();

            Account m = new Account();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(ac_id));
            }
            m.ac_code = ac_code;
            m.ac_name = ac_name;
            m.bank_name = bank_name;
            m.bank_no = bank_no;
            m.is_stop = Convert.ToInt32(is_stop);
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                if (dal.CheckExist(ac_code))
                {
                    return "账户编码" + ac_code + "已存在！";
                }
                if (dal.CheckExistName(ac_name))
                {
                    return "账户名称" + ac_name + "已存在！";
                }
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}