﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

/// <summary>
///采购订单子表
/// </summary>
public class PurchaseOrders
{
    /// <summary>
    /// 父对象
    /// </summary>
    public PurchaseOrder parent_object { get; set; }
    /// <summary>
    /// 订单主表ID
    /// </summary>
    public int po_id { get; set; }
    /// <summary>
    /// 订单子表ID
    /// </summary>
    public int pos_id { get; set; }
    /// <summary>
    /// 存货ID
    /// </summary>
    public int i_id { get; set; }
    /// <summary>
    /// 自由项1
    /// </summary>
    public string free1 { get; set; }
    /// <summary>
    /// 自由项2
    /// </summary>
    public string free2 { get; set; }
    /// <summary>
    /// 存货实体
    /// </summary>
    public Inventory inventory { get; set; }
    /// <summary>
    /// 无税单价
    /// </summary>
    public decimal? unit_price { get; set; }
    /// <summary>
    /// 含税单价
    /// </summary>
    public decimal? tax_unit_price { get; set; }
    /// <summary>
    /// 数量
    /// </summary>
    public decimal? quantity { get; set; }
    /// <summary>
    /// 累计入库数量
    /// </summary>
    public decimal? acc_in_quantity { get; set; }
    /// <summary>
    /// 累计入库件数
    /// </summary>
    public decimal? acc_in_num { get; set; }
    /// <summary>
    /// 件数
    /// </summary>
    public decimal? num { get; set; }
    /// <summary>
    /// 换算率
    /// </summary>
    public decimal? convert_rate { get; set; }
    /// <summary>
    /// 无税金额
    /// </summary>
    public decimal? total_price { get; set; }
    /// <summary>
    /// 含税金额
    /// </summary>
    public decimal? tax_total_price { get; set; }
    /// <summary>
    /// 累计付款金额
    /// </summary>
    public decimal? acc_pay_money { get; set; }
    /// <summary>
    /// 税额
    /// </summary>
    public decimal? tax { get; set; }
    /// <summary>
    /// 本币单价
    /// </summary>
    public decimal? nat_unit_price { get; set; }
    /// <summary>
    /// 本币金额
    /// </summary>
    public decimal? nat_total_price { get; set; }
    /// <summary>
    /// 本币含税单价
    /// </summary>
    public decimal? nat_tax_unit_price { get; set; }
    /// <summary>
    /// 本币含税金额
    /// </summary>
    public decimal? nat_tax_total_price { get; set; }
    /// <summary>
    /// 本币税额
    /// </summary>
    public decimal? nat_tax { get; set; }
    /// <summary>
    /// 税率
    /// </summary>
    public decimal? d_tax_rate { get; set; }
    /// <summary>
    /// 预到货日期
    /// </summary>
    public DateTime? arrive_date { get; set; }
    /// <summary>
    /// 备注
    /// </summary>
    public string d_remark { get; set; }
    /// <summary>
    /// 字符自定义项1
    /// </summary>
    public string d_sdefine1 { get; set; }
    /// <summary>
    /// 字符自定义项2
    /// </summary>
    public string d_sdefine2 { get; set; }
    /// <summary>
    /// 字符自定义项3
    /// </summary>
    public string d_sdefine3 { get; set; }
    /// <summary>
    /// 字符自定义项4
    /// </summary>
    public string d_sdefine4 { get; set; }
    /// <summary>
    /// 字符自定义项5
    /// </summary>
    public string d_sdefine5 { get; set; }
    /// <summary>
    /// 数值自定义项1
    /// </summary>
    public decimal? d_ndefine1 { get; set; }
    /// <summary>
    /// 数值自定义项2
    /// </summary>
    public decimal? d_ndefine2 { get; set; }
    /// <summary>
    /// 数值自定义项3
    /// </summary>
    public decimal? d_ndefine3 { get; set; }
    /// <summary>
    /// 数值自定义项4
    /// </summary>
    public decimal? d_ndefine4 { get; set; }
    /// <summary>
    /// 数值自定义项5
    /// </summary>
    public decimal? d_ndefine5 { get; set; }
}
